/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    public int handle;
    Tree parent;
    int background;
    int foreground;

    public TreeItem(Tree parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, 0, -65534);
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parent;
        int hItem = -65535;
        if (index != 0) {
            int count = 1;
            int hwnd = parent.handle;
            hItem = OS.SendMessage(hwnd, 4362, 0, 0);
            while (hItem != 0 && count < index) {
                hItem = OS.SendMessage(hwnd, 4362, 1, hItem);
                ++count;
            }
            if (hItem == 0) {
                this.error(6);
            }
        }
        parent.createItem(this, 0, hItem);
    }

    public TreeItem(TreeItem parentItem, int style) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        this.parent = parentItem.parent;
        int hItem = parentItem.handle;
        this.parent.createItem(this, hItem, -65534);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parentItem.parent;
        int hItem = -65535;
        int hParent = parentItem.handle;
        if (index != 0) {
            int count = 1;
            int hwnd = this.parent.handle;
            hItem = OS.SendMessage(hwnd, 4362, 4, hParent);
            while (hItem != 0 && count < index) {
                hItem = OS.SendMessage(hwnd, 4362, 1, hItem);
                ++count;
            }
            if (hItem == 0) {
                this.error(6);
            }
        }
        this.parent.createItem(this, hParent, hItem);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int pixel = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.getDisplay(), pixel);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int hwnd = this.parent.handle;
        RECT rect = new RECT();
        rect.left = this.handle;
        if (OS.SendMessage(hwnd, 4356, 1, rect) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        int result = OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        return result != 0 && (tvItem.state >> 12 & 1) == 0;
    }

    public Display getDisplay() {
        Tree parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getExpanded() {
        this.checkWidget();
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.hItem = this.handle;
        tvItem.mask = 8;
        OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        return (tvItem.state & 0x20) != 0;
    }

    public Color getForeground() {
        this.checkWidget();
        int pixel = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.getDisplay(), pixel);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        int result = OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        return result != 0 && tvItem.state >> 12 > 2;
    }

    public int getItemCount() {
        this.checkWidget();
        int count = 0;
        int hwnd = this.parent.handle;
        int hItem = OS.SendMessage(hwnd, 4362, 4, this.handle);
        while (hItem != 0) {
            hItem = OS.SendMessage(hwnd, 4362, 1, hItem);
            ++count;
        }
        return count;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int count = 0;
        int hwnd = this.parent.handle;
        int hItem = OS.SendMessage(hwnd, 4362, 4, this.handle);
        while (hItem != 0) {
            hItem = OS.SendMessage(hwnd, 4362, 1, hItem);
            ++count;
        }
        int index = 0;
        TreeItem[] result = new TreeItem[count];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = OS.SendMessage(hwnd, 4362, 4, this.handle);
        while (tvItem.hItem != 0) {
            OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
            TreeItem item = this.parent.items[tvItem.lParam];
            if (item != null) {
                result[index++] = item;
            }
            tvItem.hItem = OS.SendMessage(hwnd, 4362, 1, tvItem.hItem);
        }
        if (index != count) {
            TreeItem[] newResult = new TreeItem[index];
            System.arraycopy(result, 0, newResult, 0, index);
            result = newResult;
        }
        return result;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = OS.SendMessage(hwnd, 4362, 3, this.handle);
        if (tvItem.hItem == 0) {
            return null;
        }
        OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        return this.parent.items[tvItem.lParam];
    }

    void redraw() {
        if (this.parent.drawCount > 0) {
            return;
        }
        int hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        RECT rect = new RECT();
        rect.left = this.handle;
        if (OS.SendMessage(hwnd, 4356, 1, rect) != 0) {
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        this.background = pixel;
        this.redraw();
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        int state = tvItem.state >> 12;
        if (checked) {
            if ((state & 1) != 0) {
                ++state;
            }
        } else if ((state & 1) == 0) {
            --state;
        }
        tvItem.state = state << 12;
        OS.SendMessage(hwnd, OS.TVM_SETITEM, 0, tvItem);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        int hwnd = this.parent.handle;
        int hOldItem = OS.SendMessage(hwnd, 4362, 9, 0);
        this.parent.ignoreExpand = true;
        OS.SendMessage(hwnd, 4354, expanded ? 2 : 1, this.handle);
        this.parent.ignoreExpand = false;
        int hNewItem = OS.SendMessage(hwnd, 4362, 9, 0);
        if (hNewItem != hOldItem) {
            Event event = new Event();
            if (hNewItem != 0) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 20;
                tvItem.hItem = hNewItem;
                if (OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem) != 0) {
                    event.item = this.parent.items[tvItem.lParam];
                }
                this.parent.hAnchor = hNewItem;
            }
            this.parent.sendEvent(13, event);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        this.foreground = pixel;
        this.redraw();
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
        int state = tvItem.state >> 12;
        if (grayed) {
            if (state <= 2) {
                state += 2;
            }
        } else if (state > 2) {
            state -= 2;
        }
        tvItem.state = state << 12;
        OS.SendMessage(hwnd, OS.TVM_SETITEM, 0, tvItem);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        int hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 50;
        tvItem.iSelectedImage = tvItem.iImage = this.parent.imageIndex(image);
        tvItem.hItem = this.handle;
        OS.SendMessage(hwnd, OS.TVM_SETITEM, 0, tvItem);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        int hwnd = this.parent.handle;
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), string, true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 17;
        tvItem.hItem = this.handle;
        tvItem.pszText = pszText;
        OS.SendMessage(hwnd, OS.TVM_SETITEM, 0, tvItem);
        OS.HeapFree(hHeap, 0, pszText);
    }
}

