/*
 * Decompiled with CFR 0.152.
 */
package kamicup.xml.dom.deprecated;

import java.io.PrintStream;
import java.io.PrintWriter;
import kamicup.io.Printer;
import kamicup.xml.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomPrinter
extends Printer {
    public String Header = "<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>";

    public void setHeader(String str) {
        this.Header = str;
    }

    public void setEncoding(String encoding) {
        this.Header = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
    }

    public DomPrinter() {
    }

    public DomPrinter(PrintStream out) {
        super(out);
    }

    public DomPrinter(PrintWriter out) {
        super(out);
    }

    public void print(Document doc) {
        super.print(String.valueOf(this.Header) + "\n");
        this.printNodeRecursively(doc.getDocumentElement());
    }

    public void print(Node node) {
        this.printNodeRecursively(node);
    }

    private void printNodeRecursively(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                super.print(this.escape(node.getNodeValue()));
                break;
            }
            case 8: {
                super.print("<!--" + this.escape(node.getNodeValue()) + "-->");
                break;
            }
            case 1: {
                String name = node.getNodeName();
                NodeList children = node.getChildNodes();
                NamedNodeMap nnp = node.getAttributes();
                super.print("<" + name);
                int i = 0;
                while (i < nnp.getLength()) {
                    super.print(" " + nnp.item(i).getNodeName() + "=\"" + this.escape(nnp.item(i).getNodeValue()) + "\"");
                    ++i;
                }
                if (children.getLength() == 0) {
                    super.print("/>");
                    break;
                }
                super.print(">");
                i = 0;
                while (i < children.getLength()) {
                    this.print(children.item(i));
                    ++i;
                }
                super.print("</" + name + ">");
            }
        }
    }

    private String escape(String value) {
        return Reference.escapePredefinedEntities((String)value);
    }
}

