/*
 * Decompiled with CFR 0.152.
 */
package kamicup.xml.dom;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kamicup.xml.dom.deprecated.DomTool;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLWriter {
    private Writer writer;
    private String encoding = "Shift_JIS";
    private String method = "xml";
    private String indent = "no";
    private String mediaType = "text/xml";
    private String version = "1.0";

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public XMLWriter(Writer out) {
        this.writer = out;
    }

    public XMLWriter(File file) throws IOException {
        FileWriter out = new FileWriter(file);
        this.writer = out;
        this.encoding = out.getEncoding();
    }

    public XMLWriter(String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.writer = out;
        this.encoding = out.getEncoding();
    }

    public void print(Node node) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException, IOException {
        Writer out = this.writer;
        DOMSource xmlSource = new DOMSource(node);
        StreamResult outputTarget = new StreamResult(out);
        this.getTransformer().transform(xmlSource, outputTarget);
        out.flush();
        out.close();
    }

    public void print(Node node, File xslt) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException, ParserConfigurationException, SAXException, IOException {
        Writer out = this.writer;
        DOMSource xmlSource = new DOMSource(node);
        StreamResult outputTarget = new StreamResult(out);
        this.getTransformer(xslt).transform(xmlSource, outputTarget);
        out.flush();
        out.close();
    }

    private Transformer getTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory transfact = TransformerFactory.newInstance();
        Transformer trans = transfact.newTransformer();
        trans.setOutputProperty("encoding", this.encoding);
        trans.setOutputProperty("indent", this.indent);
        trans.setOutputProperty("media-type", this.mediaType);
        trans.setOutputProperty("method", this.method);
        trans.setOutputProperty("version", this.version);
        return trans;
    }

    private Transformer getTransformer(File xslt) throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException, SAXException, IOException {
        DOMSource xsltSource = new DOMSource(DomTool.newDocument(xslt));
        TransformerFactory transfact = TransformerFactory.newInstance();
        Transformer trans = transfact.newTransformer(xsltSource);
        trans.setOutputProperty("encoding", this.encoding);
        trans.setOutputProperty("indent", this.indent);
        trans.setOutputProperty("media-type", this.mediaType);
        trans.setOutputProperty("method", this.method);
        trans.setOutputProperty("version", this.version);
        return trans;
    }
}

