/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.swt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import javax.xml.parsers.ParserConfigurationException;
import kamicup.publication.webmanager.Converter;
import kamicup.publication.webmanager.Resource;
import kamicup.publication.webmanager.projects.Config;
import kamicup.publication.webmanager.projects.Mapping;
import kamicup.publication.webmanager.projects.Project;
import kamicup.publication.webmanager.projects.Projects;
import kamicup.publication.webmanager.projects.Rss;
import kamicup.publication.webmanager.projects.ShellCommand;
import kamicup.publication.webmanager.projects.StubFile;
import kamicup.publication.webmanager.projects.Update;
import kamicup.publication.webmanager.swt.CommentEditDialog;
import kamicup.publication.webmanager.swt.MappingEditDialog;
import kamicup.publication.webmanager.swt.ProjectEditDialog;
import kamicup.publication.webmanager.swt.RssEditDialog;
import kamicup.publication.webmanager.swt.TextEditDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.xml.sax.SAXException;

public class Window {
    static final String CMD_DAMMY = "DAMMY";
    static final String CMD_EDIT = "EDIT";
    static final String CMD_REMOVE = "REMOVE";
    static final String CMD_MKDIR = "MKDIR";
    static final String CMD_SHELL = "SHELL";
    static final String CMD_REFLESH = "REFLESH";
    static final String CMD_NEWFILE = "NEWFILE";
    static final String CMD_NEWMAPPING = "CMD_NEWMAPPING";
    static final String CMD_CREATE = "CREATE";
    static final String CMD_EXTRACT = "EXTRACT";
    private static final String TYPE_CONFIG = "TYPE_CONFIG";
    private static final String TYPE_SHELLCOMMAND = "TYPE_SHELLCOMMAND";
    private static final String TYPE_MAPPING = "TYPE_MAPPING";
    private static final String TYPE_STUBFILE = "TYPE_STUBFILE";
    private static final String TYPE_PROJECTS = "TYPE_PROJECTS";
    private static final String TYPE_PROJECT = "TYPE_PROJECT";
    private static final String TYPE_DIRECTORY = "TYPE_DIRECTORY";
    private static final String TYPE_RSS = "TYPE_RSS";
    private static final String TYPE_UPDATE = "TYPE_UPDATE";
    private Projects projects;
    private Display display;
    private Shell shell;
    private Table table;
    private Tree tree;
    private TreeEditor editor;

    public Window(File file) throws IOException, SAXException, ParserConfigurationException {
        this.projects = new Projects(file);
    }

    public Shell open(Display display) throws MalformedURLException {
        this.display = display;
        this.shell = new Shell(display);
        this.shell.setLayout(new FillLayout(512));
        SashForm sash = new SashForm(this.shell, 256);
        this.tree = new Tree(sash, 67584);
        this.tree.addSelectionListener(new TreeSelectionAdapter());
        this.editor = new TreeEditor(this.tree);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.initTree();
        this.table = new Table(sash, 67586);
        this.table.addSelectionListener(new TableSelectionAdapter());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.table, 16384);
        col1.setText("Name");
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(this.table, 131072);
        col2.setText("Size");
        col2.setWidth(60);
        TableColumn col3 = new TableColumn(this.table, 16384);
        col3.setText("Type");
        col3.setWidth(80);
        TableColumn col4 = new TableColumn(this.table, 16384);
        col4.setText("Date");
        col4.setWidth(120);
        sash.setWeights(new int[]{30, 70});
        this.shell.setImage(Resource.getImage(display, "icon.gif"));
        this.shell.setText("Legacy Web Manager 0.1.4 by Yoshikazu Hashimoto");
        if (Window.isMacOSX()) {
            this.shell.setSize(800, 480);
        } else {
            this.shell.setSize(640, 480);
        }
        this.shell.open();
        return this.shell;
    }

    private void tryInitTree() {
        try {
            this.initTree();
        }
        catch (MalformedURLException murle) {
            this.errorDialog(murle, null);
        }
    }

    private void disposeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void initTree() throws MalformedURLException {
        this.disposeEditor();
        this.tree.removeAll();
        this.parseProjects();
    }

    private void parseProjects() throws MalformedURLException {
        TreeItem tiProjects = new TreeItem(this.tree, 0);
        tiProjects.setText("Projects");
        tiProjects.setImage(Resource.getImage(this.display, "projects.png"));
        tiProjects.setData("type", TYPE_PROJECTS);
        this.parseConfig(tiProjects, this.projects.getConfig());
        int i = 0;
        while (i < this.projects.sizeProject()) {
            this.parseProject(tiProjects, this.projects.getProject(i));
            ++i;
        }
        tiProjects.setExpanded(true);
    }

    private void parseConfig(TreeItem parent, Config config) {
        TreeItem tiConfig = new TreeItem(parent, 0);
        tiConfig.setText("Config");
        tiConfig.setImage(Resource.getImage(this.display, "config.png"));
        tiConfig.setData("type", TYPE_CONFIG);
        TreeItem tiShellCommand = new TreeItem(tiConfig, 0);
        tiShellCommand.setText("Shell-Command");
        tiShellCommand.setImage(Resource.getImage(this.display, "shell.png"));
        tiShellCommand.setData("type", TYPE_SHELLCOMMAND);
        tiShellCommand.setData("shellCommand", config.getShellCommand());
        int i = 0;
        while (i < config.sizeMapping()) {
            TreeItem tiMapping = new TreeItem(tiConfig, 0);
            tiMapping.setText("Mapping (" + config.getMapping(i).getType() + ")");
            tiMapping.setImage(Resource.getImage(this.display, "mapping.png"));
            tiMapping.setData("type", TYPE_MAPPING);
            tiMapping.setData("mapping", config.getMapping(i));
            ++i;
        }
        i = 0;
        while (i < config.sizeStubFile()) {
            TreeItem tiStubFile = new TreeItem(tiConfig, 0);
            tiStubFile.setText("Stub File (" + config.getStubFile(i).getType() + ")");
            tiStubFile.setImage(Resource.getImage(this.display, "stub.png"));
            tiStubFile.setData("type", TYPE_STUBFILE);
            tiStubFile.setData("stubFile", config.getStubFile(i));
            ++i;
        }
        tiConfig.setExpanded(this.projects.getConfig().getExpand(false));
    }

    private void parseProject(TreeItem parent, Project project) throws MalformedURLException {
        TreeItem tiProject = new TreeItem(parent, 0);
        tiProject.setText(project.getName());
        tiProject.setImage(Resource.getImage(this.display, "project.png"));
        tiProject.setData("type", TYPE_PROJECT);
        tiProject.setData("project", project);
        File root = new File(project.getLocal());
        URL url = new URL(project.getUrl());
        this.parseDirectory(tiProject, root, url, 1);
        this.parseRss(tiProject, project.getRss());
        tiProject.setExpanded(true);
    }

    private void parseRss(TreeItem parent, Rss rss) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText("Update Info");
        item.setImage(Resource.getImage(this.display, "rss.png"));
        item.setData("type", TYPE_RSS);
        item.setData("rss", rss);
        int i = 0;
        while (i < rss.sizeUpdate()) {
            TreeItem tiUpdate = new TreeItem(item, 0);
            tiUpdate.setText(rss.getUpdate(i).getTitle());
            tiUpdate.setImage(Resource.getImage(this.display, "update.png"));
            tiUpdate.setData("type", TYPE_UPDATE);
            tiUpdate.setData("update", rss.getUpdate(i));
            ++i;
        }
        item.setExpanded(true);
    }

    private void parseDirectory(TreeItem parent, File directory, URL url, int depth) throws MalformedURLException {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(directory.getName());
        item.setImage(Resource.getImage(this.display, "folder.png"));
        item.setData("type", TYPE_DIRECTORY);
        item.setData("file", directory);
        item.setData("url", url);
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                URL nextUrl = new URL(url, String.valueOf(files[i].getName()) + "/");
                this.parseDirectory(item, files[i], nextUrl, depth - 1);
            }
            ++i;
        }
        if (depth > 0) {
            item.setExpanded(true);
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Projects getProjects() {
        return this.projects;
    }

    private void popCommentEditor(Update update) {
        CommentEditDialog ed = new CommentEditDialog(this, update);
        if (ed.open()) {
            update.setLink(ed.getUrl().toExternalForm());
            update.setDate(ed.getDate());
            update.setTitle(ed.getTitle());
            update.setDescription(ed.getDescription());
            this.tryInitTree();
        }
    }

    private void popCommentMaker(Rss rss) {
        CommentEditDialog ed = new CommentEditDialog(this);
        if (ed.open()) {
            Update update = new Update();
            update.setLink(ed.getUrl().toExternalForm());
            update.setDate(ed.getDate());
            update.setTitle(ed.getTitle());
            update.setDescription(ed.getDescription());
            rss.addUpdate(update);
            this.tryInitTree();
        }
    }

    private void popCommentMaker(File file, URL url) {
        CommentEditDialog ed = new CommentEditDialog(this, file, url);
        if (ed.open()) {
            Update update = new Update();
            update.setLink(ed.getUrl().toExternalForm());
            update.setDate(ed.getDate());
            update.setTitle(ed.getTitle());
            update.setDescription(ed.getDescription());
            int i = 0;
            while (i < this.projects.sizeProject()) {
                if (url.toExternalForm().startsWith(this.projects.getProject(i).getUrl())) {
                    this.projects.getProject(i).getRss().addUpdate(update);
                    if (this.projects.getProject(i).getRss().getAuto(false)) {
                        try {
                            Converter.extract(this.projects.getProject(i));
                            this.messageDialog("RSS Extract", "Auto Extract Done.\n" + file.getAbsolutePath(), null);
                        }
                        catch (Exception e) {
                            this.errorDialog(e, null);
                        }
                    }
                }
                ++i;
            }
            this.tryInitTree();
        }
    }

    private void popProjectEditor(Project project) {
        ProjectEditDialog dlg = new ProjectEditDialog(this, project);
        if (dlg.open()) {
            project.setName(dlg.getName());
            project.setLocal(dlg.getLocal().getAbsolutePath());
            project.setUrl(dlg.getUrl().toExternalForm());
            project.setAuthor(dlg.getAuthor());
            project.setDescription(dlg.getDescription());
            this.tryInitTree();
        }
    }

    private void popProjectMaker() {
        ProjectEditDialog dlg = new ProjectEditDialog(this);
        if (dlg.open()) {
            Project project = new Project();
            project.setName(dlg.getName());
            project.setLocal(dlg.getLocal().getAbsolutePath());
            project.setUrl(dlg.getUrl().toExternalForm());
            project.setAuthor(dlg.getAuthor());
            project.setDescription(dlg.getDescription());
            Rss rss = new Rss();
            rss.setAuto(true);
            rss.setFile("index.rdf");
            rss.setUrl("index.rdf");
            project.setRss(rss);
            this.projects.addProject(project);
            this.tryInitTree();
        }
    }

    private void popRssEditor(Project project) {
        try {
            RssEditDialog dlg = new RssEditDialog(this, project);
            if (dlg.open()) {
                Rss rss = project.getRss();
                rss.setAuto(dlg.getAuto());
                rss.setFile(dlg.getFile().getPath());
                rss.setUrl(dlg.getUrl().getPath());
            }
        }
        catch (MalformedURLException murle) {
            this.errorDialog(murle, null);
        }
    }

    private void popMappingEditor(Mapping mapping) {
        MappingEditDialog dlg = new MappingEditDialog(this, mapping);
        if (dlg.open()) {
            mapping.setType(dlg.getType());
            mapping.setSuffixByString(dlg.getSuffix());
            mapping.setCommand(dlg.getCommand());
            mapping.setParameter(dlg.getParameter());
            this.tryInitTree();
        }
    }

    private void popMappingMaker() {
        MappingEditDialog dlg = new MappingEditDialog(this);
        if (dlg.open()) {
            Mapping mapping = new Mapping();
            mapping.setType(dlg.getType());
            mapping.setSuffixByString(dlg.getSuffix());
            mapping.setCommand(dlg.getCommand());
            this.projects.getConfig().addMapping(mapping);
            this.tryInitTree();
        }
    }

    private void openFile(File file, URL url) {
        Mapping mapping = this.findMapping(file);
        if (mapping == null) {
            this.errorDialog("Mapping Not Found", "Command mapping not found for [" + file.getName() + "]", null);
        } else {
            String command = mapping.getCommand();
            String[] parameter = mapping.getParameter();
            Invoker ivk = new Invoker(command, parameter, file, url);
            this.display.asyncExec(ivk);
        }
    }

    private Mapping findMapping(File file) {
        String name = file.getName();
        int i = 0;
        while (i < this.projects.getConfig().sizeMapping()) {
            int j = 0;
            while (j < this.projects.getConfig().getMapping(i).sizeSuffix()) {
                if (name.endsWith(this.projects.getConfig().getMapping(i).getSuffix(j))) {
                    return this.projects.getConfig().getMapping(i);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public int errorDialog(Throwable t, String question) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return this.errorDialog(t.toString(), sw.toString(), question);
    }

    public int errorDialog(String title, String message, String question) {
        return this.messageDialog(title, message, question, 1);
    }

    public int messageDialog(String title, String message, String question) {
        return this.messageDialog(title, message, question, 4);
    }

    public int messageDialog(String title, String message, String question, int swtIcon) {
        int swtFlags;
        if (question == null || question.length() == 0) {
            swtFlags = swtIcon | 0x20;
            question = "Press OK to continue.";
        } else {
            swtFlags = swtIcon | 0x40 | 0x80;
        }
        MessageBox mb = new MessageBox(this.shell, swtFlags);
        mb.setText(title);
        mb.setMessage(String.valueOf(message) + "\n\n" + question);
        return mb.open();
    }

    static final boolean isMacOSX() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    private final class MenuItemSelectionAdapter
    extends SelectionAdapter {
        MenuItemSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.getSource();
            Object command = item.getData("command");
            TreeItem treeItem = (TreeItem)item.getParent().getData("treeItem");
            Object type = treeItem.getData("type");
            if (command == Window.CMD_DAMMY) {
                Window.this.errorDialog("Not Implemented", "This function is not available now.\nPlease edit the setting file with text editor.", null);
                return;
            }
            if (type == Window.TYPE_PROJECTS) {
                if (command == Window.CMD_CREATE) {
                    Window.this.popProjectMaker();
                }
            } else if (type == Window.TYPE_CONFIG) {
                if (command == Window.CMD_NEWMAPPING) {
                    Window.this.popMappingMaker();
                }
            } else if (type == Window.TYPE_MAPPING) {
                Mapping mapping = (Mapping)treeItem.getData("mapping");
                if (command == Window.CMD_EDIT) {
                    Window.this.popMappingEditor(mapping);
                } else if (command == Window.CMD_REMOVE) {
                    Window.this.projects.getConfig().removeMapping(mapping);
                    Window.this.tryInitTree();
                }
            } else if (type == Window.TYPE_PROJECT) {
                Project project = (Project)treeItem.getData("project");
                if (command == Window.CMD_EDIT) {
                    Window.this.popProjectEditor(project);
                } else if (command == Window.CMD_REMOVE) {
                    Window.this.projects.removeProject(project);
                    Window.this.tryInitTree();
                }
            } else if (type == Window.TYPE_DIRECTORY) {
                File file = (File)treeItem.getData("file");
                URL url = (URL)treeItem.getData("url");
                if (command == Window.CMD_SHELL) {
                    ShellCommand shellCommand = Window.this.projects.getConfig().getShellCommand();
                    String[] args = new String[2 + shellCommand.sizeParameter()];
                    args[0] = shellCommand.getCommand();
                    int i = 0;
                    while (i < shellCommand.sizeParameter()) {
                        args[i + 1] = shellCommand.getParameter(i);
                        ++i;
                    }
                    args[args.length - 1] = file.getAbsolutePath();
                    try {
                        Runtime.getRuntime().exec(args);
                    }
                    catch (IOException ioe) {
                        Window.this.errorDialog(ioe, null);
                    }
                } else if (command == Window.CMD_MKDIR) {
                    String name;
                    TextEditDialog dlg = new TextEditDialog(Window.this, "Directory Name", 256);
                    if (dlg.open() && (name = dlg.getValue()) != null && name.length() > 0) {
                        File newDir = new File(file, name);
                        newDir.mkdir();
                        Window.this.tryInitTree();
                    }
                } else if (command == Window.CMD_NEWFILE) {
                    String name;
                    StubFile stub = (StubFile)item.getData("stubFile");
                    TextEditDialog dlg = new TextEditDialog(Window.this, "File Name", 256);
                    if (dlg.open() && (name = dlg.getValue()) != null && name.length() > 0) {
                        File newFile = new File(file, name);
                        try {
                            URL newUrl = new URL(url, name);
                            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), stub.getEncoding()));
                            pw.print(stub.getContent());
                            pw.close();
                            Window.this.openFile(newFile, newUrl);
                        }
                        catch (MalformedURLException murle) {
                            Window.this.errorDialog(murle, null);
                        }
                        catch (UnsupportedEncodingException uee) {
                            Window.this.errorDialog(uee, null);
                        }
                        catch (FileNotFoundException fnfe) {
                            Window.this.errorDialog(fnfe, null);
                        }
                        new TreeSelectionAdapter().parseFile(file, url);
                    }
                } else if (command == Window.CMD_REFLESH) {
                    Window.this.tryInitTree();
                }
            } else if (type == Window.TYPE_RSS) {
                Project project;
                if (command == Window.CMD_EDIT) {
                    project = (Project)treeItem.getParentItem().getData("project");
                    Window.this.popRssEditor(project);
                }
                if (command == Window.CMD_CREATE) {
                    Rss rss = (Rss)treeItem.getData("rss");
                    Window.this.popCommentMaker(rss);
                } else if (command == Window.CMD_EXTRACT) {
                    project = (Project)treeItem.getParentItem().getData("project");
                    try {
                        File file = Converter.extract(project);
                        int res = Window.this.messageDialog("RSS Extract", "Extract Done.\n" + file.getAbsolutePath(), "Do you open it?");
                        if (res == 64) {
                            URL url = new URL(new URL(project.getUrl()), project.getRss().getUrl());
                            Window.this.openFile(file, url);
                        }
                    }
                    catch (Exception ex) {
                        Window.this.errorDialog(ex, null);
                    }
                }
            } else if (type == Window.TYPE_UPDATE) {
                Update update = (Update)treeItem.getData("update");
                if (command == Window.CMD_EDIT) {
                    Window.this.popCommentEditor(update);
                } else if (command == Window.CMD_REMOVE) {
                    Rss rss = (Rss)treeItem.getParentItem().getData("rss");
                    rss.removeUpdate(update);
                    Window.this.tryInitTree();
                }
            }
        }
    }

    private final class LabelMouseAdapter
    extends MouseAdapter {
        MenuItemSelectionAdapter adapter;

        LabelMouseAdapter() {
            this.adapter = new MenuItemSelectionAdapter();
        }

        public void mouseDown(MouseEvent e) {
            if (!(e.getSource() instanceof Label)) {
                return;
            }
            Label label = (Label)e.getSource();
            TreeItem treeItem = (TreeItem)label.getData("treeItem");
            Object type = treeItem.getData("type");
            Menu menu = new Menu(label);
            menu.setData("treeItem", treeItem);
            if (type == Window.TYPE_PROJECTS) {
                MenuItem miNewProject = new MenuItem(menu, 4);
                miNewProject.addSelectionListener(this.adapter);
                miNewProject.setText("Create New Project");
                miNewProject.setData("command", Window.CMD_CREATE);
            } else if (type == Window.TYPE_CONFIG) {
                MenuItem miNewMapping = new MenuItem(menu, 4);
                miNewMapping.addSelectionListener(this.adapter);
                miNewMapping.setText("Create New Mapping");
                miNewMapping.setData("command", Window.CMD_NEWMAPPING);
                MenuItem miNewStubFile = new MenuItem(menu, 4);
                miNewStubFile.addSelectionListener(this.adapter);
                miNewStubFile.setText("Create New Stub File");
                miNewStubFile.setData("command", Window.CMD_DAMMY);
                miNewStubFile.setEnabled(false);
            } else if (type == Window.TYPE_SHELLCOMMAND) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_DAMMY);
                miEdit.setEnabled(false);
            } else if (type == Window.TYPE_MAPPING) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_EDIT);
                MenuItem miRemove = new MenuItem(menu, 4);
                miRemove.addSelectionListener(this.adapter);
                miRemove.setText("Remove");
                miRemove.setData("command", Window.CMD_REMOVE);
            } else if (type == Window.TYPE_STUBFILE) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_DAMMY);
                miEdit.setEnabled(false);
                MenuItem miRemove = new MenuItem(menu, 4);
                miRemove.addSelectionListener(this.adapter);
                miRemove.setText("Remove");
                miRemove.setData("command", Window.CMD_DAMMY);
                miRemove.setEnabled(false);
            } else if (type == Window.TYPE_PROJECT) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_EDIT);
                MenuItem miRemove = new MenuItem(menu, 4);
                miRemove.addSelectionListener(this.adapter);
                miRemove.setText("Remove");
                miRemove.setData("command", Window.CMD_REMOVE);
            } else if (type == Window.TYPE_RSS) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_EDIT);
                MenuItem miSep1 = new MenuItem(menu, 2);
                MenuItem miNewUpdate = new MenuItem(menu, 4);
                miNewUpdate.addSelectionListener(this.adapter);
                miNewUpdate.setText("Create New Update Info");
                miNewUpdate.setData("command", Window.CMD_CREATE);
                MenuItem miSep2 = new MenuItem(menu, 2);
                MenuItem miExtractRss = new MenuItem(menu, 4);
                miExtractRss.addSelectionListener(this.adapter);
                miExtractRss.setText("Extract RSS 1.0");
                miExtractRss.setData("command", Window.CMD_EXTRACT);
            } else if (type == Window.TYPE_UPDATE) {
                MenuItem miEdit = new MenuItem(menu, 4);
                miEdit.addSelectionListener(this.adapter);
                miEdit.setText("Edit");
                miEdit.setData("command", Window.CMD_EDIT);
                MenuItem miRemove = new MenuItem(menu, 4);
                miRemove.addSelectionListener(this.adapter);
                miRemove.setText("Remove");
                miRemove.setData("command", Window.CMD_REMOVE);
            } else if (type == Window.TYPE_DIRECTORY) {
                MenuItem miOpenShell = new MenuItem(menu, 4);
                miOpenShell.addSelectionListener(this.adapter);
                miOpenShell.setText("Open by Shell");
                miOpenShell.setData("command", Window.CMD_SHELL);
                MenuItem miSep1 = new MenuItem(menu, 2);
                MenuItem miMkdir = new MenuItem(menu, 4);
                miMkdir.addSelectionListener(this.adapter);
                miMkdir.setText("Create New Directory");
                miMkdir.setData("command", Window.CMD_MKDIR);
                MenuItem miSep2 = new MenuItem(menu, 2);
                int i = 0;
                while (i < Window.this.projects.getConfig().sizeStubFile()) {
                    MenuItem miNewFile = new MenuItem(menu, 4);
                    miNewFile.addSelectionListener(this.adapter);
                    miNewFile.setText("Create New " + Window.this.projects.getConfig().getStubFile(i).getType() + " File");
                    miNewFile.setData("command", Window.CMD_NEWFILE);
                    miNewFile.setData("stubFile", Window.this.projects.getConfig().getStubFile(i));
                    ++i;
                }
                MenuItem miSep3 = new MenuItem(menu, 2);
                MenuItem miReflesh = new MenuItem(menu, 4);
                miReflesh.addSelectionListener(this.adapter);
                miReflesh.setText("Reflesh");
                miReflesh.setData("command", Window.CMD_REFLESH);
            } else {
                return;
            }
            menu.setVisible(true);
        }
    }

    private final class TreeSelectionAdapter
    extends SelectionAdapter {
        TreeSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem item = (TreeItem)e.item;
            Object type = item.getData("type");
            Window.this.disposeEditor();
            Label label = new Label(Window.this.tree, 0);
            label.addMouseListener(new LabelMouseAdapter());
            label.setText(item.getText());
            label.setData("treeItem", item);
            Window.this.editor.setEditor(label, item);
            label.setFocus();
            if (type == Window.TYPE_DIRECTORY) {
                File file = (File)item.getData("file");
                URL url = (URL)item.getData("url");
                this.parseFile(file, url);
            } else {
                Window.this.table.removeAll();
            }
        }

        public void parseFile(File file, URL url) {
            Window.this.table.removeAll();
            File[] children = file.listFiles();
            int j = 0;
            while (j < children.length) {
                if (!children[j].isDirectory()) {
                    TableItem col = new TableItem(Window.this.table, 0);
                    col.setImage(this.findIcon(children[j]));
                    col.setText(0, children[j].getName());
                    col.setText(1, String.valueOf(String.valueOf((1023L + children[j].length()) / 1024L)) + " KB");
                    col.setText(2, this.findType(children[j]));
                    col.setText(3, new Date(children[j].lastModified()).toLocaleString());
                    col.setData("file", children[j]);
                    try {
                        col.setData("url", new URL(url, children[j].getName()));
                    }
                    catch (MalformedURLException murle) {
                        Window.this.errorDialog(murle, null);
                    }
                }
                ++j;
            }
        }

        private String findType(File file) {
            String name = file.getName();
            int i = 0;
            while (i < Window.this.projects.getConfig().sizeMapping()) {
                int j = 0;
                while (j < Window.this.projects.getConfig().getMapping(i).sizeSuffix()) {
                    if (name.endsWith(Window.this.projects.getConfig().getMapping(i).getSuffix(j))) {
                        return Window.this.projects.getConfig().getMapping(i).getType();
                    }
                    ++j;
                }
                ++i;
            }
            return "";
        }

        private Image findIcon(File file) {
            Image img;
            String suffix = file.getName().substring(file.getName().lastIndexOf(46) + 1);
            Program pgm = Program.findProgram(suffix);
            ImageData idt = pgm != null ? pgm.getImageData() : null;
            Image image = img = idt != null ? new Image((Device)Window.this.display, idt) : null;
            if (img != null) {
                return img;
            }
            return Resource.getImage(Window.this.display, "file.png");
        }
    }

    private final class TableSelectionAdapter
    extends SelectionAdapter {
        TableSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TableItem item = (TableItem)e.item;
            File file = (File)item.getData("file");
            URL url = (URL)item.getData("url");
            if (file != null && url != null) {
                Window.this.openFile(file, url);
            }
        }
    }

    private final class Invoker
    implements Runnable {
        private File file;
        private String command;
        private String[] parameter;
        private URL url;

        public Invoker(String command, String[] parameter, File file, URL url) {
            this.command = command;
            this.parameter = parameter;
            this.file = file;
            this.url = url;
        }

        public void run() {
            long timeStamp = this.file.lastModified();
            String[] args = new String[2 + this.parameter.length];
            args[0] = this.command;
            int i = 0;
            while (i < this.parameter.length) {
                args[1 + i] = this.parameter[i];
                ++i;
            }
            args[args.length - 1] = this.file.getAbsolutePath();
            WaitingThread wt = new WaitingThread(args);
            new Thread(wt).start();
            while (wt.flag && !Window.this.shell.isDisposed()) {
                if (Window.this.display.readAndDispatch()) continue;
                Window.this.display.sleep();
            }
            if (timeStamp < this.file.lastModified()) {
                Window.this.popCommentMaker(this.file, this.url);
            }
        }

        private class WaitingThread
        implements Runnable {
            boolean flag = true;
            String[] command;

            public WaitingThread(String[] command) {
                this.command = command;
            }

            public void run() {
                try {
                    Runtime rt = Runtime.getRuntime();
                    Process pr = rt.exec(this.command);
                    pr.waitFor();
                }
                catch (IOException ioe) {
                    Window.this.errorDialog(ioe, null);
                }
                catch (InterruptedException ie) {
                    Window.this.errorDialog(ie, null);
                }
                this.flag = false;
            }
        }
    }
}

