/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.swt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import kamicup.publication.webmanager.projects.Project;
import kamicup.publication.webmanager.projects.Rss;
import kamicup.publication.webmanager.swt.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RssEditDialog
implements SelectionListener {
    Window window_;
    Shell shell_;
    Label lblFile;
    Label lblUrl;
    Label lblAuto;
    Text txtFile;
    Text txtUrl;
    Button btnAuto;
    Button btnOk;
    private boolean flag = false;
    private File file = null;
    private URL url = null;
    private boolean auto = false;

    public RssEditDialog(Window window) {
        this.initWidget(window);
    }

    public RssEditDialog(Window window, Project project) throws MalformedURLException {
        this.initWidget(window);
        Rss rss = project.getRss();
        File fRss = new File(rss.getFile());
        if (!fRss.getAbsolutePath().equals(rss.getFile())) {
            File fPrj = new File(project.getLocal());
            fRss = new File(fPrj, rss.getFile());
        }
        URL uPrj = new URL(project.getUrl());
        URL uRss = new URL(uPrj, rss.getUrl());
        this.txtFile.setText(fRss.getAbsolutePath());
        this.txtUrl.setText(uRss.toExternalForm());
        this.btnAuto.setSelection(rss.getAuto(false));
    }

    private void initWidget(Window window) {
        this.window_ = window;
        this.shell_ = new Shell(window.getShell(), 65648);
        this.shell_.setText("RSS");
        this.shell_.setImage(this.window_.getShell().getImage());
        this.shell_.setLayout(new GridLayout(2, false));
        this.lblFile = new Label(this.shell_, 0);
        this.lblFile.setText("File Name");
        this.lblFile.setLayoutData(new GridData());
        this.txtFile = new Text(this.shell_, 2052);
        this.txtFile.setLayoutData(new GridData(768));
        this.lblUrl = new Label(this.shell_, 0);
        this.lblUrl.setText("URL");
        this.lblUrl.setLayoutData(new GridData());
        this.txtUrl = new Text(this.shell_, 2052);
        this.txtUrl.setLayoutData(new GridData(768));
        this.lblAuto = new Label(this.shell_, 0);
        this.lblAuto.setText("Auto");
        this.lblAuto.setLayoutData(new GridData());
        this.btnAuto = new Button(this.shell_, 32);
        this.btnAuto.setText("Generate RSS when detect update.");
        this.btnAuto.setLayoutData(new GridData(768));
        this.btnOk = new Button(this.shell_, 8);
        this.btnOk.addSelectionListener(this);
        GridData btnOkGrid = new GridData(768);
        btnOkGrid.horizontalSpan = 2;
        this.btnOk.setLayoutData(btnOkGrid);
        this.btnOk.setText("OK");
    }

    public boolean open() {
        if (Window.isMacOSX()) {
            this.shell_.setSize(this.shell_.computeSize(500, 140));
        } else {
            this.shell_.setSize(this.shell_.computeSize(500, 100));
        }
        this.shell_.open();
        while (!this.shell_.isDisposed()) {
            if (this.window_.getDisplay().readAndDispatch()) continue;
            this.window_.getDisplay().sleep();
        }
        return this.flag;
    }

    public boolean getAuto() {
        return this.auto;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                this.file = new File(this.txtFile.getText());
                this.url = new URL(this.txtUrl.getText());
                this.auto = this.btnAuto.getSelection();
                this.flag = true;
                this.shell_.close();
                this.shell_.dispose();
            }
            catch (Exception ex) {
                this.window_.errorDialog(ex, null);
            }
        }
    }
}

