/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.swt;

import kamicup.publication.webmanager.projects.Mapping;
import kamicup.publication.webmanager.swt.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MappingEditDialog
implements SelectionListener {
    Window window_;
    Shell shell_;
    Label lblType;
    Label lblSuffix;
    Label lblCommand;
    Label lblParam1;
    Label lblParam2;
    Text txtType;
    Text txtSuffix;
    Text txtCommand;
    Text txtParam1;
    Text txtParam2;
    Button btnOk;
    private boolean flag = false;
    private String type = null;
    private String suffix = null;
    private String command = null;
    private String[] parameter = null;

    public MappingEditDialog(Window window) {
        this.initWidget(window);
    }

    public MappingEditDialog(Window window, Mapping mapping) {
        this.initWidget(window);
        this.txtType.setText(mapping.getType());
        this.txtSuffix.setText(mapping.getSuffixAsString());
        this.txtCommand.setText(mapping.getCommand());
        String[] params = mapping.getParameter();
        if (params.length > 0) {
            this.txtParam1.setText(params[0]);
        }
        if (params.length > 1) {
            this.txtParam2.setText(params[1]);
        }
    }

    private void initWidget(Window window) {
        this.window_ = window;
        this.shell_ = new Shell(window.getShell(), 65648);
        this.shell_.setText("Mapping");
        this.shell_.setImage(this.window_.getShell().getImage());
        this.shell_.setLayout(new GridLayout(2, false));
        this.lblType = new Label(this.shell_, 0);
        this.lblType.setText("Type");
        this.lblType.setLayoutData(new GridData());
        this.txtType = new Text(this.shell_, 2052);
        this.txtType.setLayoutData(new GridData(768));
        this.lblSuffix = new Label(this.shell_, 0);
        this.lblSuffix.setText("Suffix List");
        this.lblSuffix.setLayoutData(new GridData());
        this.txtSuffix = new Text(this.shell_, 2052);
        this.txtSuffix.setLayoutData(new GridData(768));
        this.lblCommand = new Label(this.shell_, 0);
        this.lblCommand.setText("Command");
        this.lblCommand.setLayoutData(new GridData());
        this.txtCommand = new Text(this.shell_, 2052);
        this.txtCommand.setLayoutData(new GridData(768));
        this.lblParam1 = new Label(this.shell_, 0);
        this.lblParam1.setText("Parameter(1)");
        this.lblParam1.setLayoutData(new GridData());
        this.txtParam1 = new Text(this.shell_, 2052);
        this.txtParam1.setLayoutData(new GridData(768));
        this.lblParam2 = new Label(this.shell_, 0);
        this.lblParam2.setText("Parameter(2)");
        this.lblParam2.setLayoutData(new GridData());
        this.txtParam2 = new Text(this.shell_, 2052);
        this.txtParam2.setLayoutData(new GridData(768));
        this.btnOk = new Button(this.shell_, 8);
        this.btnOk.addSelectionListener(this);
        GridData btnOkGrid = new GridData(768);
        btnOkGrid.horizontalSpan = 2;
        this.btnOk.setLayoutData(btnOkGrid);
        this.btnOk.setText("OK");
    }

    public boolean open() {
        if (Window.isMacOSX()) {
            this.shell_.setSize(this.shell_.computeSize(500, 220));
        } else {
            this.shell_.setSize(this.shell_.computeSize(500, 150));
        }
        this.shell_.open();
        while (!this.shell_.isDisposed()) {
            if (this.window_.getDisplay().readAndDispatch()) continue;
            this.window_.getDisplay().sleep();
        }
        return this.flag;
    }

    public String getCommand() {
        return this.command;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getType() {
        return this.type;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                this.type = this.txtType.getText();
                this.suffix = this.txtSuffix.getText();
                this.command = this.txtCommand.getText();
                this.parameter = this.makeParam();
                this.flag = true;
                this.shell_.close();
                this.shell_.dispose();
            }
            catch (Exception ex) {
                this.window_.errorDialog(ex, null);
            }
        }
    }

    private String[] makeParam() {
        String p1 = this.txtParam1.getText();
        String p2 = this.txtParam2.getText();
        if (p1 != null && p1.length() > 0 && p2 != null && p2.length() > 0) {
            return new String[]{p1, p2};
        }
        if (p1 != null && p1.length() > 0) {
            return new String[]{p1};
        }
        if (p2 != null && p2.length() > 0) {
            return new String[]{p2};
        }
        return new String[0];
    }
}

