/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.swt;

import java.io.File;
import java.net.URL;
import java.sql.Timestamp;
import kamicup.publication.webmanager.projects.Update;
import kamicup.publication.webmanager.swt.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommentEditDialog
implements SelectionListener {
    Window window_;
    Shell shell_;
    Label lblUrl;
    Label lblDate;
    Label lblTitle;
    Label lblDescription;
    Text txtUrl;
    Text txtDate;
    Text txtTitle;
    Text txtDescription;
    Button btnOk;
    private boolean flag = false;
    private URL url = null;
    private Timestamp date = null;
    private String title = null;
    private String description = null;

    public CommentEditDialog(Window window, File file, URL url) {
        this.initWidget(window);
        this.txtUrl.setText(url.toExternalForm());
        this.txtDate.setText(new Timestamp(file.lastModified()).toString());
    }

    public CommentEditDialog(Window window, Update update) {
        this.initWidget(window);
        this.txtUrl.setText(update.getLink());
        this.txtDate.setText(update.getDate().toString());
        this.txtTitle.setText(update.getTitle());
        this.txtDescription.setText(update.getDescription());
    }

    public CommentEditDialog(Window window) {
        this.initWidget(window);
        this.txtUrl.setText("http://");
        this.txtDate.setText(new Timestamp(System.currentTimeMillis()).toString());
    }

    private void initWidget(Window window) {
        this.window_ = window;
        this.shell_ = new Shell(window.getShell(), 65648);
        this.shell_.setText("Update Comment");
        this.shell_.setImage(this.window_.getShell().getImage());
        this.shell_.setLayout(new GridLayout(2, false));
        this.lblUrl = new Label(this.shell_, 0);
        this.lblUrl.setText("URL");
        this.lblUrl.setLayoutData(new GridData());
        this.txtUrl = new Text(this.shell_, 2052);
        this.txtUrl.setLayoutData(new GridData(768));
        this.lblDate = new Label(this.shell_, 0);
        this.lblDate.setText("Date");
        this.lblDate.setLayoutData(new GridData());
        this.txtDate = new Text(this.shell_, 2052);
        this.txtDate.setLayoutData(new GridData(768));
        this.lblTitle = new Label(this.shell_, 0);
        this.lblTitle.setText("Title");
        this.lblTitle.setLayoutData(new GridData());
        this.txtTitle = new Text(this.shell_, 2052);
        this.txtTitle.setLayoutData(new GridData(768));
        this.lblDescription = new Label(this.shell_, 0);
        this.lblDescription.setText("Description");
        this.lblDescription.setLayoutData(new GridData());
        this.txtDescription = new Text(this.shell_, 2050);
        this.txtDescription.setLayoutData(new GridData(1808));
        this.btnOk = new Button(this.shell_, 8);
        this.btnOk.addSelectionListener(this);
        GridData btnOkGrid = new GridData(768);
        btnOkGrid.horizontalSpan = 2;
        this.btnOk.setLayoutData(btnOkGrid);
        this.btnOk.setText("OK");
    }

    public boolean open() {
        if (Window.isMacOSX()) {
            this.shell_.setSize(this.shell_.computeSize(500, 240));
        } else {
            this.shell_.setSize(this.shell_.computeSize(500, 200));
        }
        this.shell_.open();
        while (!this.shell_.isDisposed()) {
            if (this.window_.getDisplay().readAndDispatch()) continue;
            this.window_.getDisplay().sleep();
        }
        return this.flag;
    }

    public URL getUrl() {
        return this.url;
    }

    public Timestamp getDate() {
        return this.date;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                this.url = new URL(this.txtUrl.getText());
                this.date = Timestamp.valueOf(this.txtDate.getText());
                this.title = this.txtTitle.getText();
                this.description = this.txtDescription.getText();
                this.flag = true;
                this.shell_.close();
                this.shell_.dispose();
            }
            catch (Exception ex) {
                this.window_.errorDialog(ex, null);
            }
        }
    }
}

