#!/usr/bin/env ruby

$: << "./src"

require 'webrick'
require 'KakiRequestHandler.rb'
require 'config.rb'
require 'KakiServ_config.rb'

$port_number = 8888 unless $port_number
server = WEBrick::HTTPServer.new( :Port => $port_number )

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
	$page_data_source.use_cache = $use_cache 
	$page_data_source.use_memory_cache = $use_memory_cache 
end

class WikiServlet < WEBrick::HTTPServlet::AbstractServlet
	def do_GET(req, res)
		app = KakiRequestHandler.new($page_data_source, req.meta_vars, req.query);

		app.template_dir = $template_dir if $template_dir
		app.theme_dir = $theme_dir if $theme_dir
		app.theme_base_url = $theme_base_url if $theme_base_url
		app.main()
		header = app.response_header
		body = app.response_body

		header.each(){ |key, value|
			res[key] = value
		}
		res.body =  body
	end

	def do_POST(req, res)
		do_GET(req, res)
	end
end

class RedirectServlet < WEBrick::HTTPServlet::AbstractServlet
	def do_GET(req, res)
		res.set_redirect(WEBrick::HTTPStatus::MovedPermanently.new, '/kaki')
	end
	def do_POST(req, res) do_GET(req, res); end
	def do_HEAD(req, res) do_GET(req, res); end
end

server.mount("/", RedirectServlet)
server.mount("/kaki", WikiServlet)
server.mount("/theme", WEBrick::HTTPServlet::FileHandler, "./theme")
server.mount("/files", WEBrick::HTTPServlet::FileHandler, "./files")

trap("INT"){ server.shutdown }
server.start

