
module Wiki

class NoTemplateError < StandardError; end

class TemplateDataSource

	def initialize(root_dir)
		self.root_dir = root_dir
		self.cache_table = Hash.new
	end

	def template(file_name, language_list)
		tmpl_path = nil
		tmpl_lang = nil
		language_list.each(){ |l|
			path = "#{self.root_dir}/#{l}/#{file_name}"
			if File.file?(path) and File.readable?(path) then
				tmpl_path = path
				tmpl_lang = l
				break;
			end
		}
		raise NoTemplateError.new unless tmpl_path

		result = cache_table[tmpl_path]
		unless result then
			result =  File.readlines(tmpl_path).to_s
			cache_table[tmpl_path] = result
		end

		return [result, tmpl_lang];
	end

protected
	attr :root_dir, true
	attr :cache_table, true

end

end
