// $Id: DBLimitElm.cpp,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBLimitElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGLimitManager.h"
#include "dbio/DBLimitElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBLimitElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBLimitElm::load");

    JGLimitManager * limitManager =
                        (JGLimitManager *)equip->findManager(CATEGORY_LIMIT);
    JGLimitTable * limit_tbl = limitManager->validTable();
    DBView<DBLimitElm> view(_TX("G_LIMITS"));

    DBView<DBLimitElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBLimitElm * limit_elm = (DBLimitElm *)(&(*read_it));
        JGid vid(limit_elm->m_vidStr);
        limit_elm->vid(vid);
                                        // Convert CEID string to intteger.
        int ceint = _tcstol(limit_elm->m_ceidStr.c_str(), NULL, 10);
        JGid ceid(ceint);
        limit_elm->ceid(ceid);
        JGVariable * var = equip->variable(vid);
        if (var == NULL)
        {
            TRACE_ERROR((_TX("Variable is not found (%s) \n"),
                         vid.toString().c_str()));
            continue;
        }
        limit_elm->variable(var);
        int format = var->format();
        if (limit_elm->m_maxstr.size() > 0)
        {
            if (limit_elm->m_maxval.set(limit_elm->m_maxstr, format) < 0)
            {
                TRACE_ERROR((_TX("Illegal max value (%s).\n"),
                             vid.toString().c_str()));
            }
        }
        if (limit_elm->m_minstr.size() > 0)
        {
            if (limit_elm->m_minval.set(limit_elm->m_minstr, format) < 0)
            {
                TRACE_ERROR((_TX("Illegal min value (%s).\n"),
                             vid.toString().c_str()));
            }
        }

        limit_elm->enabled((limit_elm->m_enabledStr == _TX("true")) ?
                                                       true : false);
        limit_elm->manager(limitManager);
        limit_tbl->insert(JGLimitPair(vid, *read_it));
    }

    return ;
}

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBLimitBorderElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBLimitBorderElm::load");

    JGLimitManager * limitManager =
                        (JGLimitManager *)equip->findManager(CATEGORY_LIMIT);
    JGLimitTable * limit_tbl = limitManager->validTable();

    DBView<DBLimitBorderElm> view(_TX("G_LIMIT_ATTRS"));
    DBView<DBLimitBorderElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBLimitBorderElm * limit_border = (DBLimitBorderElm *)(&(*read_it));
        JGid vid(limit_border->m_vidStr);
        limit_border->vid(vid);

        limit_border->enabled((limit_border->m_enabledStr == _TX("true")) ?
                              true : false);

        JGLimitTable::iterator limit_it = limit_tbl->find(vid);
        if (limit_it != limit_tbl->end())
        {   // Append limit border
            JGLimit * limit = &((*limit_it).second);
            limit->insert(*limit_border);
#if 0       // if chack limit id
            if (result != BEE_SUCCESS)
            {
                TRACE_ERROR((_TX("Duplicate Limit Border %s %d\n"),
                             limit_border->m_vidStr.c_str(),
                             limit_border->limitId()));
            }
#endif
        }
        else
        {
            TRACE_ERROR((_TX("Unliked Limit Border %s %d\n"),
                         limit_border->m_vidStr.c_str(),
                         limit_border->limitId()));
        }

        JGVariable * var = equip->variable(vid);
        if (var == NULL)
        {
            TRACE_ERROR((_TX("Variable is not found (%s) \n"),
                         limit_border->m_vidStr.c_str()));
            continue;
        }
        int format = var->format();
        if (limit_border->m_upperdb.size() > 0)
        {
            if (limit_border->m_upval.set(limit_border->m_upperdb, format) < 0)
            {
                TRACE_ERROR((_TX("Illegal upperdb value (%s).\n"),
                             limit_border->m_vidStr.c_str()));
            }
        }
        if (limit_border->m_lowerdb.size() > 0)
        {
            if (limit_border->m_lowval.set(limit_border->m_lowerdb, format) < 0)
            {
                TRACE_ERROR((_TX("Illegal lowerdb value (%s).\n"),
                             limit_border->m_vidStr.c_str()));
            }
        }
    }
    return ;
}

