// $Id: DBConfigElm.cpp,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBConfigElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "dbio/DBConfigElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBConfigElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBConfigElm::load");

    JGInfoManager * infoManager =
                        (JGInfoManager *)equip->findManager(CATEGORY_INFO);
    JGConfigTable * conf_tbl = infoManager->configTable();
    DBView<DBConfigElm> view(_TX("G_CONFIG"));
    DBView<DBConfigElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBConfigElm * configElm = (DBConfigElm *)(&(*read_it));

        JGid vid(configElm->m_vidstr);
        configElm->vid(vid);
        conf_tbl->insert(JGConfigPair(configElm->name(), *read_it));
    }
    return ;
}

