// $Id: JGProcessManager.cpp,v 1.12 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGProcessManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGProcessManager.h"
#include "JGProcess.h"
#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGTaskTrigger.h"


//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
static JGProcessManager * _manager = NULL;

JGProcessManager * JGProcessManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::instance");
    if (_manager == NULL)
    {
        _manager = new JGProcessManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Constructor/Destoructor
//-----------------------------------------------------------------------------
JGProcessManager::JGProcessManager() : JGManager(CATEGORY_PROCESS)
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::JGProcessManager");
}


//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGProcessManager::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::init");
    long procNum = (long)parm;
    if (procNum == 0)
    {
        procNum = 1;
    }

    for (int i = 0; i < procNum; i++)
    {
        BCHAR buf[256];
        _stprintf(buf, _TX("PROCESS_%c"), ('A' + i));
        string procName = buf;
        JGProcess * proc = new JGProcess(i+1, procName);
        m_procs.push_back(proc);

        proc->equipment(m_equipment);
        proc->init();
    }

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Open a service thread.
//-----------------------------------------------------------------------------
int JGProcessManager::open(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::open");

    if (this->JGManager::open(parm) < 0)
    {
        return BEE_ERROR;
    }

    for (size_t i = 0; i < m_procs.size(); i++)
    {
        m_procs[i]->device(m_device);
        m_procs[i]->open(parm);
    }

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Accept trigger from the variable.
//-----------------------------------------------------------------------------
int JGProcessManager::notify(const string& category, JGVariable * var,
                             void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::notify");
    ACE_UNUSED_ARG(arg);

    TRACE_ERROR((_TX("%s : %s = %s\n"), category.c_str(), var->charName(),
                                        var->getv().toString().c_str()));

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Accept trigger by remote command.
//-----------------------------------------------------------------------------
int JGProcessManager::notify(JGService * rcmd)
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::notify");

    TRACE_ERROR((_TX("%s -> %s\n"), rcmd->charName(), rcmd->to().c_str()));

    int result;
    int procid = 1;
    //
    // Get process id in rcmd
    //

    JGProcess * target = NULL;
    for (size_t i = 0; i <m_procs.size(); i++)
    {
        if (procid == m_procs[i]->procNumber())
        {
            target = m_procs[i];
        }
    }
    if (target == NULL)
    {   // Not found the process
        return 6;                // NOT_EXIST_OBJECT
    }

    if ((result = target->enable(rcmd->name())) != 0)
    {
        return result;           // 1:ILLEGAL_RCMD or 2:CANNOT_PERFORM
    }

    target->notify(rcmd);
    result = 4;                  // PERFORM_LATER
    return result;
}

//----------------------------------------------------------------------------
// Is process active or not
//-----------------------------------------------------------------------------
bool JGProcessManager::isActive()
{
    TRACE_FUNCTION(TRL_LOW, "JGProcessManager::active");

    for (size_t i = 0; i <m_procs.size(); i++)
    {
        if (m_procs[i]->isActive())
        {
            return true;
        }
    }
    return false;
}


