// $Id: JGEventManager.h,v 1.1 2003/02/09 16:16:12 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEventManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGEVENTMANAGER_H
#define JGEVENTMANAGER_H

#include "JGManager.h"
#include "JGEvent.h"
#include "JGDefineEvent.h"

class BS2Message;
class BS2Item;

/*
 * Manage Event Class
 */
class BEE_Export JGEventManager: public JGManager
{
public:
    JGEventManager();
    ~JGEventManager();

    // virtual int svc(void);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int init(void * = 0);

    JGEvent * find(JGid& ceid);
    JGReport * findReport(JGid& rptid);
    JGEventTable *  eventTable()  { return &m_evtable; }
    JGReportTable * reportTable() { return &m_rptable; }
    JGActionTable * actionTable() { return &m_actable; }

    int request(JGManager * mngr, const string& evt, JGVariable * var = NULL);

    static JGEventManager * instance();

private:
    BS2Message * createEventReport(JGid& ceid, JGVariable * var = NULL);
    BS2Message * defineReport(BS2Message * msg);      // S2F33
    BS2Message * linkEventReport(BS2Message * msg);   // S2F35
    BS2Message * setEnabled(BS2Message * msg);        // S2F37
    BS2Message * eventReportList(BS2Message * msg);   // S6F15
    BS2Message * individualReport(BS2Message * msg);  // S6F19
    void releaseReport(JGid& rptid);
    int  applyReport(JGReport& defined);
    int  reqSend(JGManager * mngr, const string& evt, JGVariable * var = NULL);
    void resetCeed(JGReport& report);

//
private:
    JGEventTable    m_evtable;
    JGReportTable   m_rptable;
    JGActionTable   m_actable;

};


#endif
