// $Id: JGDefineVariable.h,v 1.5 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDefineVariable.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEFINEVARIABLE_H
#define JGDEFINEVARIABLE_H

//-----------------------------------------------------------------------------
//  Item of configuration
//
#define CONF_EQUIP_NAME         _TX("Equipment Name")  // JGEquipment
#define CONF_IDENTIFIER_TYPE    _TX("IdentifierType")  // JGEquipment
#define CONF_DEVICE_ID          _TX("Device Number")   // InfoManager
#define CONF_SOURCE_ID          _TX("Source ID")       // InfoManager
#define CONF_PROTOCOL           _TX("Protocol")        // InfoManager
#define CONF_BAUDRATE           _TX("Baudrate")        // InfoManager
#define CONF_SECS_T1            _TX("T1")              // InfoManager
#define CONF_SECS_T2            _TX("T2")              // InfoManager
#define CONF_SECS_T3            _TX("T3S")             // InfoManager
#define CONF_SECS_T4            _TX("T4")              // InfoManager
#define CONF_SECS_RETRY         _TX("Retry")           // InfoManager
#define CONF_SECS_PORT          _TX("Comm Port")       // InfoManager
#define CONF_MASTER             _TX("Master")          // InfoManager
#define CONF_HSMS_IP            _TX("IP")              // InfoManager
#define CONF_HSMS_PORT          _TX("Port")            // InfoManager
#define CONF_HSMS_T3            _TX("T3H")             // InfoManager
#define CONF_HSMS_T5            _TX("T5")              // InfoManager
#define CONF_HSMS_T6            _TX("T6")              // InfoManager
#define CONF_HSMS_T7            _TX("T7")              // InfoManager
#define CONF_HSMS_T8            _TX("T8")              // InfoManager
#define CONF_VAL_SECS               _TX("SECS")        //  (configuration value)
#define CONF_VAL_HSMS               _TX("HSMS")        //  (configuration value)
#define CONF_VAL_YES                _TX("YES")         //  (configuration value)
#define CONF_VAL_NO                 _TX("NO")          //  (configuration value)

#define CONF_TERMINAL_COUNT     _TX("Terminal Count")     // TerminalManager
#define CONF_TERMINAL_IDS       _TX("Terminal Ids")       // TerminalManager
#define CONF_MMAP_FILENAME      _TX("Memory mapped file name")   // DBIODeviceElm
#define CONF_LIMIT_CEID         _TX("LimitEventName")     // JGLimit
#define CONF_MAX_RECIPE_COUNT   _TX("Recipe Count")       // JGProcProgManager
#define CONF_PPGNT_RETRY_TIME   _TX("PPLoadRetryTime")    // JGProcProgManager
#define CONF_SPOOL_FILENAME     _TX("Spool file name")    // JGSpoolManager
#define CONF_MAX_SPOOL_COUNT    _TX("Max spool count")    // JGSpoolManager
#define CONF_USE_PLCTIMER       _TX("PLCTimer")           // JGTimeModule
#define CONF_MAX_TRACE_COUNT    _TX("MaxTrace")           // JGTraceManager
#define CONF_MAX_TRACE_SVID     _TX("MaxTraceSVID")       // JGTraceManager

#define CONF_PC_DELAY_TIME      _TX("PCStandByDelay")
#define CONF_ROOTPATH           _TX("Root")

//-----------------------------------------------------------------------------
//  hard register of condition
//
#define REG_PC_READY                    _TX("PCReady")

//-----------------------------------------------------------------------------
//  E5 6.7 : Variable Item Dictionary
//
#define VAR_ALARM_ID                    _TX("AlarmID")
#define VAR_ALARM_ENABLED               _TX("AlarmsEnabled")
#define VAR_ALARMS_SET                  _TX("AlarmsSet")
#define VAR_CHANGED_ECID                _TX("ChangedECID")
#define VAR_CHANGED_ECNAME              _TX("ChangedECNAME")
#define VAR_CHANGED_ECV                 _TX("ChangedECV")
#define VAR_CLOCK                       _TX("Clock")
#define VAR_COMM_INITIATE               _TX("CommunicationsInitiate")
#define VAR_COMM_STATE                  _TX("CommunicationsState")
#define VAR_COMM_STATE_SELECTOR         _TX("CommunicationsStateSelector")
#define VAR_COMM_SYSTEM_DEFAULT         _TX("CommunicationsStateSystemDefault")
#define VAR_CONTROL_STATE               _TX("ControlState")
#define VAR_CONTROL_SELECTOR            _TX("ControlSelector")
#define VAR_CONTROL_SYSTEM_DEFAULT      _TX("ControlStateSystemDefault")
#define VAR_ENABLE_SPOOL                _TX("EnableSpooling")
#define VAR_EQUOP_MODEL                 _TX("EqpModel")
#define VAR_EQUIP_NAME                  _TX("EqpName")
#define VAR_EQUIP_SERIAL_NUM            _TX("EqpSerialNum")
#define VAR_EQUIP_SOFTREV               _TX("EqpSoftRev")
#define VAR_ECV_CHANGED_STATUS          _TX("EquipmentConstantStatus")
#define VAR_ESTABLISH_TIMEOUT           _TX("EstablishCommunicationTimeout")
#define VAR_EVENTS_ENABLED              _TX("EventsEnabled")
#define VAR_EVENT_LIMIT                 _TX("EventLimit")
#define VAR_LIMIT_VARIABLE              _TX("LimitVariable")
#define VAR_LOCAL_COMMAND               _TX("LocalCommand")
#define VAR_LOCATION_ID                 _TX("LocationID")
#define VAR_LOCATION_STATUS             _TX("LocationStatus")
#define VAR_MAX_SPOOL_TRANSMIT          _TX("MaxSpoolTransmit")
#define VAR_OFFLINE_SYSTEM_DEFAULT      _TX("OfflineStateSystemDefault")
#define VAR_ONLINE_SYSTEM_DEFAULT       _TX("OnlineStateSystemDefault")
#define VAR_OPERATOR_COMMAND            _TX("OperatorCommand")
#define VAR_COMMAND_INDICATOR           _TX("OperatorCommandIndicator")
#define VAR_OVERWRITE_SPOOL             _TX("OverWriteSpool")
#define VAR_PP_CHANGE_NAME              _TX("PPChangeName")
#define VAR_PP_CHANGE_LIST              _TX("PPChangeList")
#define VAR_PP_CHANGE_STATUS            _TX("PPChangeStatus")
#define VAR_PP_ERROR                    _TX("PPError")
#define VAR_PP_EXEC_NAME                _TX("PPExecName")
#define VAR_PP_FORMAT                   _TX("PPFormat")
#define VAR_PREV_PROCESS_STATE          _TX("PreviousProcessState")
#define VAR_PROCESS_STATE               _TX("ProcessState")
#define VAR_RCP_CHANGE_NAME             _TX("RcpChangeName")
#define VAR_RCP_CHANGE_STATUS           _TX("RcpChangeStatus")
#define VAR_RCP_EXEC_NAME               _TX("RcpExecName")
#define VAR_REMOTE_COMMAND              _TX("RemoteCommand")
#define VAR_SPOOL_COUNT_ACTUAL          _TX("SpoolCountActual")
#define VAR_SPOOL_COUNT_TOTAL           _TX("SpoolCountTotal")
#define VAR_SPOOL_FULL_TIME             _TX("SpoolFullTime")
#define VAR_SPOOL_START_TIME            _TX("SpoolStartTime")
#define VAR_TIME_FORMAT                 _TX("TimeFormat")
#define VAR_TRANSITION_TYPE             _TX("TransitionType")

//-----------------------------------------------------------------------------
// Program Variables
//
#define VAR_HOST_MESSAGE                _TX("HostMessage")
#define VAR_HOST_MESSAGE_RECOGNITION    _TX("HostMessageRecognition")
#define VAR_HOST_MESSAGE_RECEIVED       _TX("HostMessageReceived")
#define VAR_TREMINAL_MESSAGE            _TX("TerminalMessage")
#define VAR_TREMINAL_MESSAGE_SEND       _TX("TerminalMessageSend")

#endif
