// $Id: JGObserver.cpp,v 1.2 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObserver.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGObserver.h"


//-----------------------------------------------------------------------------
// Notify trigger to own activation queue.
//-----------------------------------------------------------------------------
int JGObserver::notify(JGTrigger * trigger)
{
    return m_activation_queue.enqueue(new TriggerRequest(trigger, this));
}

//-----------------------------------------------------------------------------
// Callback application program.
//-----------------------------------------------------------------------------
int JGObserver::TriggerRequest::call()
{
    return m_observer->update(m_trigger);
}


//-----------------------------------------------------------------------------
// Thread service
//-----------------------------------------------------------------------------
int JGObserver::svc()
{
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("(%t) JGObserver::svc start.\n")));

    int  result = 0;

    for (;;)
    {
        auto_ptr<ACE_Method_Request> mo(this->m_activation_queue.dequeue());

        ACE_DEBUG ((LM_DEBUG, "(%t) calling method object\n"));
        // Call it.
        if (mo->call() == -1)
            break;

        // Destructor automatically deletes it.
    }

    if (result == -1 && errno == EWOULDBLOCK)
    {
        ACE_ERROR((LM_ERROR,
              ACE_TEXT("(%t) %p\n"), "timed out waiting for message"));
    }

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("(%t) JGObserver::svc end.\n")));
    return 0;
}
