// $Id: MELMemory.h,v 1.3 2002/10/12 09:11:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    MELMemory.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef MELMEMORY_H
#define MELMEMORY_H

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include <vector>
using namespace std;
#include "PLCMemory.h"
#if !defined(PLC_SHARED_MEMORY)
#ifndef mdopen
#include "Mdfunc.h"
#endif
#endif

// device type
enum
{
#if !defined(PLC_SHARED_MEMORY)
    MELDEV_X             = DevX,        // *      // CC-Link
    MELDEV_Y             = DevY,        // *      // CC-Link
    MELDEV_L             = DevL,        // *
    MELDEV_M             = DevM,        // *
    MELDEV_SM            = DevSM,                 // CC-Link
    MELDEV_F             = DevF,        // *
    MELDEV_TT            = DevTT,
    MELDEV_TC            = DevTC,       // *
    MELDEV_CT            = DevCT,
    MELDEV_CC            = DevCC,       // *
    MELDEV_TN            = DevTN,       // *
    MELDEV_CN            = DevCN,       // *
    MELDEV_D             = DevD,        // *
    MELDEV_SD            = DevSD,                 // CC-Link
    MELDEV_TM            = DevTM,
    MELDEV_TS            = DevTS,       // *
    MELDEV_TS2           = DevTS2,
    MELDEV_TS3           = DevTS3,
    MELDEV_CM            = DevCM,
    MELDEV_CS            = DevCS,       // *
    MELDEV_C2            = DevCS2,
    MELDEV_C3            = DevCS3,
    MELDEV_A             = DevA,
    MELDEV_Z             = DevZ,        // *
    MELDEV_V             = DevV,        // *
    MELDEV_R             = DevR,        // *
    MELDEV_ER            = DevER1,
    MELDEV_ZR            = (DevER1-1),  // *
    MELDEV_B             = DevB,        // *
    MELDEV_W             = DevW,        // *
    MELDEV_QSB           = DevQSB,
    MELDEV_STT           = DevSTT,
    MELDEV_STC           = DevSTC,
    MELDEV_QSW           = DevQSW,
    MELDEV_QV            = DevQV,
    MELDEV_STN           = DevSTN,
    MELDEV_LX            = DevLX(0),
    MELDEV_LY            = DevLY(0),
    MELDEV_LB            = DevLB(0),
    MELDEV_LW            = DevLW(0),
    MELDEV_LSB           = DevLSB(0),
    MELDEV_LSW           = DevLSW(0),
    MELDEV_MRB           = DevMRB,
    MELDEV_WW            = DevWw,
    MELDEV_WR            = DevWr,
    MELDEV_SPB           = DevSPB,
    MELDEV_RBM           = DevRBM,
    MELDEV_RAB           = DevRAB,
    MELDEV_RX            = DevRX,
    MELDEV_RY            = DevRY,
    MELDEV_RW            = DevRW,
    MELDEV_SB            = DevSB,       // *
    MELDEV_SW            = DevSW,       // *

#else 
    MELDEV_X             = 1,         // CC-Link
    MELDEV_Y             = 2,         // CC-Link 
    MELDEV_L             = 3,
    MELDEV_M             = 4,
    MELDEV_SM            = 5,        // CC-Link
    MELDEV_F             = 6,
    MELDEV_TT            = 7,
    MELDEV_TC            = 8,
    MELDEV_CT            = 9,
    MELDEV_CC            = 10,
    MELDEV_TN            = 11,
    MELDEV_CN            = 12,
    MELDEV_D             = 13,
    MELDEV_SD            = 14,        // CC-Link
    MELDEV_TM            = 15,
    MELDEV_TS            = 16,
    MELDEV_TS2           = 16002,
    MELDEV_TS3           = 16003,
    MELDEV_CM            = 17,
    MELDEV_CS            = 18,
    MELDEV_C2            = 18002,
    MELDEV_C3            = 18003,
    MELDEV_A             = 19,
    MELDEV_Z             = 20,
    MELDEV_V             = 21,
    MELDEV_R             = 22,
    MELDEV_ER            = 22001, 
    MELDEV_ZR            = 22000,         // ??????
    MELDEV_B             = 23,
    MELDEV_W             = 24,
    MELDEV_QSB           = 25,
    MELDEV_STT           = 26,
    MELDEV_STC           = 27,
    MELDEV_QSW           = 28,
    MELDEV_QV            = 30,
    MELDEV_STN           = 35,
    MELDEV_LX            = 1001,
    MELDEV_LY            = 2002, 
    MELDEV_LB            = 23001,
    MELDEV_LW            = 24001,
    MELDEV_LSB           = 25001,
    MELDEV_LSW           = 28001,

    MELDEV_MRB           = 33,
    MELDEV_WW            = 36,
    MELDEV_WR            = 37,
    MELDEV_SPB           = 50,
    MELDEV_RBM           = 32768,
    MELDEV_RAB           = 32800,
    MELDEV_RX            = 32801,
    MELDEV_RY            = 32802,
    MELDEV_RW            = 32804,
    MELDEV_SB            = 32867,
    MELDEV_SW            = 32868,
#endif
};

#define MEL_NORMAL       (0)

enum { MELMEM_UNKNOWN = 0, MELMEM_BIT, MELMEM_WORD, MELMEM_ZR };
enum { ACS_HEX, ACS_DEC };

class MELDeviceManager;

//------------------------------------------------------------------------------
// Word Device Register
//------------------------------------------------------------------------------
class BEE_Export MELWordMemory : public PLCWordMemory
{
public:
    MELWordMemory(const char * devname, int cd, size_t memSize, long base = 0,
                  bool cclink = false, int access = ACS_HEX)
            : PLCWordMemory(devname, cd, memSize, base),
              m_accessType(access), m_cclink(cclink) {}
    virtual ~MELWordMemory() {}

    virtual int read(long address,  size_t size, u_short * data) const;
    virtual int write(long address, size_t size, u_short * data);
    virtual int put(long address, u_short data);
    virtual u_short get(long address) const;
//
protected:
    int  m_accessType;                // Device Access Mode: HEX or DECIMAL
    bool m_cclink;
};

//------------------------------------------------------------------------------
// Bit Device Register
//------------------------------------------------------------------------------
class BEE_Export MELBitMemory : public PLCBitMemory
{
public:
    MELBitMemory(const char * devname, int cd, size_t memSize, long base = 0,
                 bool cclink = false, int access = ACS_HEX)
            : PLCBitMemory(devname, cd, memSize, base),
              m_accessType(access), m_cclink(cclink) {}
    ~MELBitMemory() {}

    virtual int read(long address,  size_t size, u_short * data) const;
    virtual int write(long address, size_t size, u_short * data);
    virtual int put(long address, u_short data);
    virtual u_short get(long address) const;

protected:
    int  m_accessType;                // Device Access Mode: HEX or DECIMAL
    bool m_cclink;

};

//------------------------------------------------------------------------------
// Extend file register classe
//------------------------------------------------------------------------------
class BEE_Export MEL_ZR_Memory : public MELWordMemory
{
public:
    MEL_ZR_Memory(long base = 0) 
        : MELWordMemory("ZR", MELDEV_ZR, 0xFE800, base) { }

    virtual int open(long bus, long stnum, long address = 0, long offset = 0);
    virtual int close();
    virtual int read(long address,  size_t size, u_short * data) const;
    virtual int write(long address, size_t size, u_short * data);
    virtual int put(long address, u_short data);
    virtual u_short get(long address) const;

protected:
    int calcAddress(long address, int& retdev, long& retaddr);

    int send(short devtype, u_short addr, u_short * iosize, 
             u_short * data);
    int receive(short devtype, u_short addr, u_short * iosize,
                u_short * data) const;
    int randRead(short * devp, u_short * bufp,
                 u_short bufsize) const;
    int randWrite(short * devp, u_short * bufp, u_short bufsize);

// variables;
#if defined(PLC_SHARED_MEMORY)
    vector<ACE_Mem_Map *> m_mmaps;          // Memory Map File for ER 
#endif
};

#endif
