// $Id: alarmCmd.cpp,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    alarmCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGAlarmManager.h"
#include "tclbee.h"

#ifdef _MSC_VER
#include <windows.h>
#endif

// function prototype
static int dump_alarms(Tcl_Interp * interp, JGAlarmManager * alarmManager);
static JGAlarm * find_alarm(Tcl_Interp * interp, 
                            JGAlarmManager * alarmManager, char * alidStr);

/*
 *----------------------------------------------------------------------
 *
 * Gem_alarmCmd --
 *
 *      This procedure is invoked to process the "gem::alarm"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Gem_alarmCmd(ClientData arg, Tcl_Interp * interp, int objc,
             Tcl_Obj *CONST objv[])
{
    static char *gemcmds[] = {
        "init",
        "set",
        "get",
        "dump",
        NULL
    };
    /*
     * All commands enums below ending in X are compatibility
     */
    enum gemcmds {
        GEMCMD_INIT,
        GEMCMD_SET,
        GEMCMD_GET,
        GEMCMD_DUMP,
    };

    Tcl_Obj * res;
    int     cmdindex, result;
    JGAlarm * alarm;
    char *  boolStr;
    string  buf;

    Tcl_ResetResult(interp);
    result = TCL_OK;
    JGEquipment * jyugem = (JGEquipment *)arg;
    JGAlarmManager * alarmManager = jyugem->getAlarmManager();
    /*
     * Get the command name index from the object based on the cmds
     * defined above.
     */
    if (Tcl_GetIndexFromObj(interp,
        objv[1], (const char **)gemcmds, "command", TCL_EXACT, &cmdindex) != TCL_OK)
        return TCL_ERROR;

    if (objc >= 3)
    {
        // Find variable by alid
        alarm = find_alarm(interp, alarmManager, 
                           Tcl_GetStringFromObj(objv[2], NULL));
        if (alarm == NULL)
        {
            return TCL_ERROR;
        }
    }

    res = NULL;
    switch ((enum gemcmds)cmdindex) {
    case GEMCMD_INIT:
        break;
    case GEMCMD_SET:
        if (objc != 4)
        {
            Tcl_WrongNumArgs(interp, 2, objv, "alid enabled");
            return TCL_ERROR;
        }

        // Convert string to value
        boolStr = Tcl_GetStringFromObj(objv[3], NULL);
        alarm->enabled((EQUALSTR(boolStr, "true")) ? true : false);
        break;
    case GEMCMD_GET:
        if (objc != 3)
        {
            Tcl_WrongNumArgs(interp, 2, objv, "alid");
            return TCL_ERROR;
        }
        Tcl_AppendResult(interp, (alarm->enabled()) ? "true" : "false", NULL);
        break;

    case GEMCMD_DUMP:
        if (objc == 2)
        {
            dump_alarms(interp, alarmManager);
        }
        else if (objc == 3)
        {
            alarm->printOn(buf);
            Tcl_AppendResult(interp, "{", NULL);            // print header
            Tcl_AppendResult(interp, buf.c_str(), NULL);
            Tcl_AppendResult(interp, "} ", NULL);
        }
        else
        {
            Tcl_WrongNumArgs(interp, 2, objv, "?alid ?");
            return TCL_ERROR;
        }
        break;

    }

    /*
     * For each different arg call different function to create
     * new commands (or if version, get/return it).
     */
    if (result == TCL_OK && res != NULL)
        Tcl_SetObjResult(interp, res);

    return TCL_OK;
}

/*----------------------------------------------------------------------
 * Dump all variables
 *----------------------------------------------------------------------
 */
static int dump_alarms(Tcl_Interp * interp, JGAlarmManager * alarmManager)
{
    string buf;

    // Variable tables in the equipment
    JGAlarmTable * alarmtbl = alarmManager->alarmTable();
    JGAlarmTable::iterator alarm_it = alarmtbl->begin();

    for ( ; alarm_it != alarmtbl->end(); ++alarm_it)
    {
        JGAlarm * alarm = &((*alarm_it).second);
        alarm->printOn(buf);

        Tcl_AppendResult(interp, "{", NULL);            // print header
        Tcl_AppendResult(interp, buf.c_str(), NULL);
        Tcl_AppendResult(interp, "} ", NULL);
    }
    return TCL_OK;
}

//---------------------------------------------------------------------------
// Parse alid in command parameter
//---------------------------------------------------------------------------
static JGAlarm * find_alarm(Tcl_Interp * interp, JGAlarmManager * alarmManager,
                            char * alidStr)
{
    unsigned int num = strtoul(alidStr, NULL, 0);
    if (num == 0)
    {
        Tcl_AppendResult(interp, "Illegal ALID : ", alidStr, NULL);
        return NULL;
    }
    BS2id alid = num;

    JGAlarm * alarm = alarmManager->find(alid);
    return alarm;
}

