// $Id: RecipeExecutorModel.h,v 1.2 2002/10/12 09:11:52 fukasawa Exp $

//=============================================================================
/**
 *  @file    RecipeExecutorModel.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef RECIPEEXECUTORMODEL_H
#define RECIPEEXECUTORMODEL_H

#include "JGManager.h"
#include "JGRecipe.h"

class ExecutionRecipeModel;
class JGRecipe;

/*
 * Recipe Manager Class
 */
class RecipeExecutorModel
{
public:
    RecipeExecutorModel();
    ~RecipeExecutorModel();

    int init(int = 0);

    ExecutionRecipeModel * find(JGid& rcpid);

    int remove();                            // Remove all recipe
    int remove(JGid& rcpid);
    int deselect();                          // Deselect all recipe
    int deselect(JGid& rcpid);
    int upload(JGid& rcpid, JGRecipe& recipe);
    int download(JGid& rcpid, JGRecipe& recipe);
    int verify(JGid& rcpid);

};


#endif  /* RECIPEEXECUTORMODEL_H */
