// $Id: DBSpoolElm.cpp,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBSpoolElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGSpoolManager.h"
#include "dbio/DBSpoolElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBSpoolElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBSpoolElm::load");

    JGSpoolManager * spoolManager =
                        (JGSpoolManager *)equip->findManager(CATEGORY_SPOOL);
    DBView<DBSpoolElm> view(_TX("G_SPOOL_PRI"));

    DBView<DBSpoolElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBSpoolElm spool_elm = (*read_it);
        int sfnum = spool_elm.sfnum();
        spoolManager->entry(sfnum);
    }
}

