// $Id: JGScalarSub.cpp,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGScalarSub.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGScalarSub.h"
#include "JGManager.h"

//-----------------------------------------------------------------------------
//
// Scalar Base
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGScalarSubBase& JGScalarSubBase::operator=(const JGScalarSubBase& rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGScalarSubBase::operator=");
    if (this == &rhs)
        return *this;
    (JGTriggerSubject&)(*this) = rhs;
    m_relation = rhs.m_relation;
    return *this;
}

//-----------------------------------------------------------------------------
// Factory
//-----------------------------------------------------------------------------
JGTriggerInfo * JGScalarSubBase::factory()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGScalarSubBase::factory");
    JGScalarSub * sub = new JGScalarSub(this);
    return sub;
}


//-----------------------------------------------------------------------------
//
// Scalar
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Initial
//-----------------------------------------------------------------------------
int JGScalarSub::init()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGScalarSub::init");
    return this->JGTriggerInfo::init();
}

//-----------------------------------------------------------------------------
// As changed, issue trigger.
//-----------------------------------------------------------------------------
int JGScalarSub::changed()
{
    TRACE_FUNCTION(TRL_LOW, "JGScalarSub::changed");

    m_subject->manager()->notify(m_subject->trigName(), m_var,
                                 NULL);

    //
    // Reset trigger variable
    //

    return BEE_SUCCESS;
}

