// $Id: JGPluralSub.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGComplexSub.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGPLURALSUB_H
#define JGPLURALSUB_H

#include "JGTriggerInfo.h"

class JGPluralSub;
class JGVariable;

//
// Complex device access of base class
//
class JGPluralSubBase : public JGTriggerSubject
{
public:
    JGPluralSubBase() : JGTriggerSubject(), m_entity(NULL) {}
    JGPluralSubBase(const JGTriggerSubject& rhs)
            : JGTriggerSubject(rhs), m_entity(NULL) {}
    virtual ~JGPluralSubBase() {}

    JGPluralSubBase& operator=(const JGPluralSubBase& rhs);
    virtual JGTriggerInfo * factory() { return NULL; }
    virtual JGTriggerInfo * entity();
    virtual bool            isGroup() { return true; }

    JGVariable * relation()         { return m_relation; }
    void relation(JGVariable * var) { m_relation = var; }
    int parse();
    string& enumerate(int num) {
            return (num < (int)m_enames.size()) ?
                       m_enames[num] : JGTriggerSubject::_NilString;
        }
//
private:
    vector<string> m_enames;
    JGVariable  * m_relation;         // Relational(watchdog) variable
    JGPluralSub * m_entity;
};


//
// Plural device access of class
//
typedef JGTriggerInfoTempl<JGPluralSubBase>  JGTrigPlural;

class JGPluralSub : public JGTrigPlural
{
public:
    JGPluralSub(JGPluralSubBase * base)
            : JGTrigPlural(base), m_entry(false) {}
    virtual ~JGPluralSub() {}

    virtual int  init();
    virtual int  sense();
    virtual int  changed();
    virtual void add(JGVariable * var) { m_members.push_back(var); }
    virtual void copyRelation();

    JGVariable * relation()         { return m_relation; }
    void relation(JGVariable * var) { m_relation = var; }

    bool entry()           { return m_entry; }
    void entry(bool yesno) { m_entry = yesno; }

private:
    JGVariable * m_relation;        // Relational variable
    bool       m_entry;
    vector<JGVariable *> m_members;           // Member variables
};


#endif  /* JGPLURALSUB_H */
