// $Id: JGObject.h,v 1.7 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObject.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGOBJECT_H
#define JGOBJECT_H

#include "jyugem.h"
#include "JGErrorList.h"

class JGClass;
class JGAttribute;
class JGAttrData;
class BS2Item;

//
// Attribute filter
//
struct JGAttrFilter
{
    enum
    {
        EQUAL         = 0,
        NOT_EQUAL     = 1,
        LESS          = 2,
        LESS_OR_EQUAL = 3,
        GREATER       = 4,
        GREATER_EQUAL = 5,
        PRESENT       = 6,
        ABSENT        = 7,
        CONTAIND      = 8,
        NOT_CONTAINED = 9
    };

    JGAttrFilter() : m_attrid(0), m_attrdata(0), m_attrreln(EQUAL) {};
    JGAttrFilter(const JGAttrFilter& rhs) {
            m_attrid = rhs.m_attrid;
            m_attrdata = rhs.m_attrdata;
            m_attrreln = rhs.m_attrreln;
            m_link = rhs.m_link;
        }
    JGAttrFilter& operator=(const JGAttrFilter& rhs) {
            if (this == &rhs)
                return *this;
            m_attrid = rhs.m_attrid;
            m_attrdata = rhs.m_attrdata;
            m_attrreln = rhs.m_attrreln;
            m_link = rhs.m_link;
            return *this;
        }

    // variables
    JGid    m_attrid;
    JGvalue m_attrdata;
    int     m_attrreln;
    vector<JGAttrFilter> m_link;
};

//
// Object
//
class JGObject : public b_object
{
public:

    class Setter
    {
        friend class JGObject;

        struct NodeInfo
        {
            JGAttribute * m_attr;
            JGAttrData * m_nodedata;
            JGAttrData * m_attrdata;
            int  m_layer;              // nest count
            int  m_row;
            bool m_dummy;
            //
            int          m_dummyCount;
            JGAttrData * m_beforeNode;

            NodeInfo() : m_attr(NULL), m_nodedata(NULL), m_attrdata(NULL),
                         m_layer(3), m_row(0), m_dummy(false),
                         m_dummyCount(0), m_beforeNode(NULL) {}
            NodeInfo(const NodeInfo& rhs) { copy(rhs); }
            NodeInfo& operator=(const NodeInfo& rhs)
            {
                if (this == &rhs)
                    return *this;
                copy(rhs);
                return *this;
            }

            void copy(const NodeInfo& rhs)
            {
                m_attr = rhs.m_attr;
                m_nodedata = rhs.m_nodedata;
                m_attrdata = rhs.m_attrdata;
                m_layer = rhs.m_layer;
                m_row = rhs.m_row;
                m_dummy = rhs.m_dummy;
                m_dummyCount = rhs.m_dummyCount;
                m_beforeNode = rhs.m_beforeNode;
            }
        };

    public:
        Setter() : m_obj(NULL), m_errs(NULL), m_topLayer(3),
                   m_objMember(false) {
                m_current.m_layer = m_topLayer;
            }
        virtual ~Setter() {}

        int setID(JGid& id, int nest);
        int setData(JGvalue& data, int nest);
        int enterList(int nest);
        int exitList(int nest);

    protected:
        Setter(JGObject * obj, JGErrorList * errs)
                : m_obj(obj), m_errs(errs), m_topLayer(3),
                  m_objMember(false) {
                m_current.m_layer = m_topLayer;
            }
        int setSameLevelID(string& attrid);
        int setSameLevelDATA(JGvalue& value);
        int downLayer();
        int upLayer();

    private:
        JGObject *    m_obj;
        JGErrorList * m_errs;
        int           m_topLayer;   // top nest num = 3
        NodeInfo      m_current;
        stack<NodeInfo> m_save;
        bool          m_objMember;
    };

public:
    virtual ~JGObject();

    virtual int link() { return BEE_SUCCESS; }

    // Create items
    BS2Item * makeObjSpec();
    BS2Item * makeAttrList();
    BS2Item * makeAttrList(vector<JGid>& attrids);
    BS2Item * makeIDandAttrList(vector<JGid>& attrids);

    // Create attrdata setter
    Setter start(JGErrorList * errs) { Setter h(this, errs); return h; }

    // Check relationship of attributes
    int relation(vector<JGAttrFilter>& filters, JGErrorList& err);

    // Set attribute data
    int set(vector<JGAttrFilter>& filters, JGErrorList& err);

    void setBase(void * p) { m_base = p; } // Set base object
    void * getBase() { return m_base; }    // Get base object
    void dump() const;

    // Wrapper methods
    inline JGClass * getObjType() {
            return reinterpret_cast<JGClass *>(this->b_object::getObjType());
        }
    inline JGAttrData * findData(const string& name) {
            return reinterpret_cast<JGAttrData *>(this->b_object::findData(name));
        }
    inline const JGAttribute * findAttr(const string& name) {
            return reinterpret_cast<const JGAttribute *>(this->b_object::findAttr(name));
        }
//
protected:
    JGObject(JGClass * clazz, const BCHAR * name = NULL);
    JGObject(const JGObject& rhs);
    JGObject& operator=(const JGObject& rhs);

//
protected:
    void * m_base;
};

typedef vector<JGObject *>   JGObjects;

#endif  /* JGOBJECT_H */
