// $Id: JGAlarmManager.h,v 1.5 2003/02/09 16:15:13 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGArarmManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGALARMMANAGER_H
#define JGALARMMANAGER_H

#include "JGManager.h"
#include "JGAlarm.h"

class BS2Message;
class BS2Item;

/*
 * Alarm manager class
 */
class BEE_Export JGAlarmManager: public JGManager
{
public:
    JGAlarmManager();
    ~JGAlarmManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    int init(void * = 0);
    int initAlarmsSet();

    JGAlarm * find(JGid&  alid);
    int changeEnabled(JGid& id, bool eflag);
    int changeEnabledAll(bool eflag);
    BS2Message * detectAlarm(JGid& id, bool status);
    BS2Item * createAlarmSet();
    int updateAlarmSet(JGid& id, bool status);

    JGAlarmTable * alarmTable() { return &m_alarmtbl; }
    JGAlarms *     alarms()     { return &m_alarms; }
    static JGAlarmManager * instance();

private:
    BS2Message * alarmList(BS2Message * msg);
    BS2Message * alarmEnabledList(BS2Message * msg);
    BS2Message * setEnabled(BS2Message * msg);
    void linkAlarms();
    JGAlarm * find(JGVariable * var);
//
private:
    JGAlarmTable m_alarmtbl;
    JGAlarms     m_alarms;
    JGAlarmMap   m_alarmMap;    // Alarms are mapped by vid.

    // = ACE_Thread_Mutex and condition variable for synchronizing termination.
    ACE_Thread_Mutex m_lock;

};

#endif
