// $Id: b_context.h,v 1.4 2003/03/16 14:50:58 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_context.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_CONTEXT_H
#define B_CONTEXT_H

#include "b_ace.h"
#include "state/b_statenode.h"
#include "state/b_trigger.h"
#include "state/b_matrix.h"

#define TRIGGER_START    "START"
#define TRIGGER_TIMEOUT  "TIMEOUT"
#define TRIGGER_FINISH   "FINISH"

// Forward declaration
class b_trigger;
class b_transition;

typedef b_matrix<b_transition *> StateMatrix;
typedef map<const string, int, str_less, allocator<int> >
        TriggerMap;
typedef TriggerMap::value_type TriggerPair;

//-----------------------------------------------------------------------------
//
// State Context
//
//-----------------------------------------------------------------------------
class BEE_Export b_context
{
public:
    typedef map<string, b_state *, str_less, allocator<b_state *> >
            StateDictionary;

//
public:
    b_context(const string& name);
    virtual ~b_context() { }

    void  name(const BCHAR * name) { m_name = name; }
    const string& name()          { return m_name; }
    const string& current(int num = 0)   { return m_root->current(num); }
    b_state * state(const string& sname) { return m_states[sname]; }
    b_state * currentState(int num = 0)  {
            return m_states[m_root->current(num)];
        }
    int numCurrent() const               { return m_root->size(); }
    int change(const string& sname);        // change current state
    int makeStateTable();

    virtual int init()                    { return this->initTransitions(); }
    virtual int initTransitions()         { return BEE_SUCCESS; }
    virtual int start();
    virtual int end()                     { return BEE_SUCCESS; }
    virtual int update(b_state * current);
    virtual int put(b_trigger * trigger);
    virtual int unexpect(b_trigger * trigger);

    int  enable(const string& trigName);
    int  accept(b_trigger * trigger);
    void dump() const;

    static RootState Root;

protected:
    b_context() {}

    int  append(b_state * state, const BCHAR * trigger, b_transition * trans) {
            string trigStr(trigger);
            return this->append(state, trigStr, trans);
        }
    int  append(b_state * state, string& trigger, b_transition * trans);
    int  acceptNext(b_state * curState, b_state * newState,
                    b_trigger * trigger);

//
protected:
    string     m_name;
    b_rootnode * m_root;
    StateMatrix     m_table;
    StateDictionary m_states;
    TriggerMap      m_triggers;
};


#endif
