// $Id: PLCMemory.h,v 1.4 2003/03/16 14:51:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    PLCMemory.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef PLCMEMORY_H
#define PLCMEMORY_H

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include <string>
using namespace std;
#include "ace/streams.h"
#include "ace/OS.h"
#include "ace/Mem_Map.h"
#include "PLCDevice.h"

class PLCDeviceManager;

/* bit handling */
const int BITS_OF_SHORT  = 16;
const int MASK_OF_SHORT  = 15;           /* = % */

//------------------------------------------------------------------------------
// PLC Device Register
//------------------------------------------------------------------------------
class BEE_Export PLCMemory : public PLCDevice
{
public:
    enum { MEM_BIT, MEM_WORD };

    PLCMemory(const ACE_TCHAR * name, int devcd, int memtype, size_t msize,
              long base = 0)
            : PLCDevice(name, devcd, memtype, msize, base) {}
    virtual ~PLCMemory() {}

    virtual int open(long bus, long stnum, long address = 0, long offset = 0);
    virtual int close();
    virtual int read(long address, size_t size, u_short * data) const = 0;
    virtual int write(long address, size_t size, u_short * data) = 0;
    virtual int put(long address, u_short data) = 0;
    virtual u_short get(long address) const = 0;
    virtual size_t words() const = 0;
    virtual int  setvm(long address, size_t size, u_short * data) = 0;
    virtual int  vmread(long address, size_t size, u_short * data) const = 0;
    virtual u_short vmget(long address) const = 0;
    virtual void dump(long top = 0, size_t size = ACTION_END) const = 0;

    static void pathName(string& name);
    static bool SetClearMemory(bool flag);
//
protected:
    u_short * m_vmaddr;          // virtual memory address

#if defined(PLC_SHARED_MEMORY)
    ACE_Mem_Map m_mmap;                 // Memory Map File
    int mapOpen(ACE_Mem_Map& mmptr, string& fname, size_t size, long address,
                long offset);
#endif
};

//------------------------------------------------------------------------------
// Word Device Register
//------------------------------------------------------------------------------
class BEE_Export PLCWordMemory : public PLCMemory
{
public:
    PLCWordMemory(const ACE_TCHAR * name, int cd, size_t msize, long base = 0)
        : PLCMemory(name, cd, MEM_WORD, msize, base) {}
    ~PLCWordMemory() {}

    virtual size_t words() const { return this->m_areaSize; }
    virtual int  setvm(long address, size_t size, u_short * data);
    virtual int  vmread(long address, size_t size, u_short * data) const;
    virtual u_short vmget(long address) const;
    virtual void dump(long top = 0, size_t size = ACTION_END) const;

protected:

};

//------------------------------------------------------------------------------
// Bit Device Register
//------------------------------------------------------------------------------
class BEE_Export PLCBitMemory : public PLCMemory
{
public:
    PLCBitMemory(const ACE_TCHAR * name, int cd, size_t msize, long base = 0)
        : PLCMemory(name, cd, MEM_BIT, msize, base) {}
    ~PLCBitMemory() {}

    virtual size_t words() const    { return ((m_areaSize + 15) / 16); }
    virtual int  setvm(long address, size_t size, u_short * data);
    virtual int  vmread(long address, size_t size, u_short * data) const;
    virtual u_short vmget(long address) const;
    virtual void dump(long top = 0, size_t size = ACTION_END) const;

    static unsigned int BitPattern[];

protected:

};


#endif
