// $Id: PLCDeviceManager.h,v 1.5 2002/12/15 15:04:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    PLCDeviceManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef PLCDEVICEMANAGER_H
#define PLCDEVICEMANAGER_H

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include <stdlib.h>
#include <assert.h>
#include <map>
#include <vector>
using namespace std;

#include "BEE_Export.h"
#include "PLCAddress.h"
class PLCDevice;

const int MAX_IODEVICE = 64;

//------------------------------------------------------------------------------
// PLC Device Manager
//------------------------------------------------------------------------------
class BEE_Export PLCDeviceManager
{
public:
    PLCDeviceManager(ACE_TCHAR * filename = NULL);
    virtual ~PLCDeviceManager();

    virtual int init(const ACE_TCHAR * pname = NULL, const ACE_TCHAR * xml = NULL,
                     int chan = 12, int stnum = 1, int unit = 0xFF);
    virtual int fini() { return 0; }
    virtual int parseAddress(const string& addrStr, PLCAccess& paccess) const;
    virtual const ACE_TCHAR * errmsg(int errcode) const;  // Get PLC Error Message
    virtual int getClock(struct tm& rettm);
    virtual int setClock(struct tm& newtm);

    int  getChannel() const    { return m_channel; }
    long getPath() const       { return m_path; }
    int  getStationNum() const { return m_stationNum; }
    int  getCount() const      { return m_iodev.size(); }
    PLCDevice * get(const char * devname) const;
    PLCDevice * get(int devcode) const;
    PLCDevice * getByPos(int offset) {
            return (m_iodev.size() > (size_t)offset) ? m_iodev[offset] : NULL;
        }
    vector<PLCDevice *>& getDevices() { return m_iodev; }
    int     read(PLCAddress& address, size_t size, u_short * data) const;
    int     write(PLCAddress& address, size_t size, u_short * data);
    int     put(PLCAddress& address, u_short data);
    u_short get(PLCAddress& address) const;
    void    dump() const;

    static PLCDeviceManager * instance();
    static PLCDeviceManager * instance(PLCDeviceManager * child);

protected:
    int add(PLCDevice * mem);

protected:
    string m_basedir;                 // plc working directory
    string m_filename;                // memory strage name
    int    m_channel;                 // Channel Number
    long   m_path;                    // Device Path
    int    m_stationNum;              // Station Number
    int    m_unit;                    // Unit Number

    int  m_usage;                     // Used Device count
    vector<PLCDevice *> m_iodev;      // I/O Device Object

};


#endif
