// $Id: MELDeviceManager.h,v 1.3 2002/12/15 15:04:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    MELDeviceManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef MELDEVICEMANAGER_H
#define MELDEVICEMANAGER_H

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "ace/Mem_Map.h"
#include "PLCDeviceManager.h"

class MELXmlParser;

//-----------------------------------------------------------------------------
// Virtual melsec memory.
//-----------------------------------------------------------------------------
struct VirtualDevice
{
    int    m_devcode;
    size_t m_size;
    u_long m_offset;

};

//-----------------------------------------------------------------------------
struct VirtualMelsec
{
    size_t        m_devq;
    VirtualDevice m_vdevs[1];

};


//------------------------------------------------------------------------------
// MELSEC Device Manager
//------------------------------------------------------------------------------
class BEE_Export MELDeviceManager : public PLCDeviceManager
{
public:
    MELDeviceManager(char * filename = NULL) : PLCDeviceManager(filename) {}
    virtual ~MELDeviceManager();

    virtual int init(const char * pname = NULL, const char * xmlname = NULL,
                     int chan = 12, int stnum = 1, int unit = 0xFF);
    virtual int fini();
    virtual int parseAddress(const string& addrStr, PLCAccess& paccess) const;
    virtual const char * errmsg(int errcode) const; // Get MELSEC Error Message
    virtual int getClock(struct tm& rettm);
    virtual int setClock(struct tm& newtm);

    int    initRegisters(MELXmlParser * xmlParser);
    static MELDeviceManager * instance();
    static MELDeviceManager * instance(MELDeviceManager * child);
//
protected:
    int initDefaultRegisters();
    int setVirtualAddress();

//
protected:
    ACE_Mem_Map     m_melmmap;
    VirtualMelsec * m_vmtop;

};


#endif
