// $Id: tclbee.h,v 1.2 2003/03/16 14:51:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    tclbee.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef TCLBEE_H
#define TCLBEE_H

#include "tcl.h"

#ifndef BOUNDARY
#define BOUNDARY     0
#define NO_BOUNDARY  1
#endif

#ifndef DUMP_BYTE
#define DUMP_BYTE       0x0000
#define DUMP_WORD       0x0001
#define DUMP_CHARCODE   0x0002
#endif

#ifndef EQUALSTR
#define EQUALSTR(s, c)    ((*s == *c) && (strcmp(s, c) == 0))
#endif

extern void bee_memdump(Tcl_Interp * interp, char * startp, size_t size,
                        int chmod);
extern int bee_parsebytes(Tcl_Interp * interp, char * datastr, BYTE ** bufpp,
                          size_t * size);
extern int bee_parsewords(Tcl_Interp * interp, char * datastr, BYTE ** bufpp,
                          size_t * size);

#endif
