// $Id: spoolCmd.cpp,v 1.2 2003/03/10 15:45:08 fukasawa Exp $

//=============================================================================
/**
 *  @file    spoolCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "JGEquipment.h"
#include "JGSpoolManager.h"
#include "BS2Message.h"
#include "tclbee.h"

#ifdef _MSC_VER
#include <windows.h>
#endif

// function prototype

/*
 *----------------------------------------------------------------------
 *
 * Gem_spoolCmd --
 *
 *      This procedure is invoked to process the "gem::spool"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Gem_spoolCmd(ClientData arg, Tcl_Interp * interp, int objc,
                Tcl_Obj *CONST objv[])
{
    // MELDeviceManager * melmngr;
    static char *gemcmds[] = {
        "clear",
        "start",
        "stop",
        "purge",
        "dump",
        "enabled",
        NULL
    };
    /*
     * All commands enums below ending in X are compatibility
     */
    enum gemcmds {
        SPOOL_CLEAR,
        SPOOL_START,
        SPOOL_STOP,
        SPOOL_PURGE,
        SPOOL_DUMP,
        SPOOL_ENABLED,
    };

    Tcl_Obj * res;
    int  cmdindex, result;
    JGid vid;

    JGEquipment * jyugem = (JGEquipment *)arg;
    JGSpoolManager * spool = (JGSpoolManager *)jyugem->findManager(CATEGORY_SPOOL);

    Tcl_ResetResult(interp);
    result = TCL_OK;

    if (objc < 2) {
        Tcl_WrongNumArgs(interp, 1, objv, "spool");
        return TCL_ERROR;
    }
    /*
     * Get the command name index from the object based on the spoolcmds
     * defined above.
     */
    if (Tcl_GetIndexFromObj(interp,
        objv[1], (const char **)gemcmds, "spool", TCL_EXACT, &cmdindex) != TCL_OK)
        return TCL_ERROR;

    res = NULL;
    switch ((enum gemcmds)cmdindex) {
    case SPOOL_CLEAR:
        {
            JGSpoolManager::clear();
            break;
        }
        break;
    case SPOOL_START:
        {
            spool->startSpool();
            break;
        }
        break;
    case SPOOL_STOP:
        {
            spool->stopSpool();
            break;
        }
        break;
    case SPOOL_PURGE:
        {
            spool->purgeSpool();
            break;
        }
        break;
    case SPOOL_DUMP:
        {
            spool->dump();
            break;
        }
    case SPOOL_ENABLED:
        {
            if (! (objc == 4 || objc == 5))
            {
                Tcl_WrongNumArgs(interp, 2, objv, "on/off/get stream ?function?");
                return TCL_ERROR;
            }
            // Convert string to value
            int stnum = 0;
            int funum = 0;
            if (objc >= 4)
            {
                result = Tcl_GetIntFromObj(interp, objv[3], &stnum);
                if (objc == 5)
                {
                    result = Tcl_GetIntFromObj(interp, objv[4], &funum);
                }
            }
            string actStr = Tcl_GetString(objv[2]);
            if (actStr == "on")
            {
                 spool->entry(SFCODE(stnum, funum));
            }
            else if (actStr == "off")
            {
                 spool->release(SFCODE(stnum, funum));
            }
            else if (actStr == "get")
            {
                 bool onoff = spool->status(SFCODE(stnum, funum));
                 Tcl_AppendResult(interp, (onoff) ? "true" : "false", NULL);
            }
            else
            {
                Tcl_AppendResult(interp, "Illegal command : ",
                                          actStr.c_str(), NULL);
                return TCL_ERROR;
            }
        }
        break;

    }

    /*
     * For each different arg call different function to create
     * new commands (or if version, get/return it).
     */
    if (result == TCL_OK && res != NULL)
        Tcl_SetObjResult(interp, res);

    return TCL_OK;
}

