// $Id: gemCmd.cpp,v 1.5 2003/03/10 15:45:08 fukasawa Exp $

//=============================================================================
/**
 *  @file    gemCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "JGEquipment.h"
#include "PLCMemory.h"
#include "tclbee.h"
#ifdef _MSC_VER
#include <windows.h>
#endif

static bool _initialized = false;

// This table is used to convert number to pattern

/*
 *----------------------------------------------------------------------
 *
 * Gem_openCmd --
 *
 *      This procedure is invoked to process the "gem::open"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int Gem_openCmd(ClientData arg, Tcl_Interp * interp, int objc,
                Tcl_Obj *CONST objv[])
{
    static char * opencmds[] = {
        "-dsn",
        "-path",
        "-plc",
        NULL
    };
    /*
     * All commands enums below ending in X are compatibility
     */
    enum opencmds {
        OPEN_DSN,
        OPEN_PATH,
        OPEN_PLC,
    };

    int cmdindex, result = TCL_OK;
    char * pathName = "\\jyugem\\jyugem\\bin";
    char * dsnName = "UID=jyugem;PWD=jyugem;DSN=MySQL;";
#ifndef _DEBUG
    char * plcName = "melsec";
#else
    char * plcName = "melshm_d";
#endif

    Tcl_ResetResult(interp);

    /*
     * Get the command name index from the object based on the spoolcmds
     * defined above.
     */
    int end = objc;
    int i = 1;
    while (i < end)
    {
        if (Tcl_GetIndexFromObj(interp, objv[i], (const char **)opencmds, "option",
                                TCL_EXACT, &cmdindex) != TCL_OK) {
            return TCL_ERROR;
        }
        i++;
        switch ((enum opencmds)cmdindex)
        {
        case OPEN_PATH:
            if (i > (end - 1)) {
                Tcl_WrongNumArgs(interp, 2, objv, "?-path pathname?");
                result = TCL_ERROR;
                break;
            }
            pathName = Tcl_GetStringFromObj(objv[i++], NULL);
            break;
        case OPEN_DSN:
            if (i > (end - 1)) {
                Tcl_WrongNumArgs(interp, 2, objv, "?-dsn dataset-name?");
                result = TCL_ERROR;
                break;
            }
            dsnName = Tcl_GetStringFromObj(objv[i++], NULL);
            break;
        case OPEN_PLC:
            if (i > (end - 1)) {
                Tcl_WrongNumArgs(interp, 2, objv, "?-plc dll-name?");
                result = TCL_ERROR;
                break;
            }
            plcName = Tcl_GetStringFromObj(objv[i++], NULL);
            break;
        }
        if (result != TCL_OK)
            break;
    }
    if (result == TCL_ERROR)
        return (result);

    PLCMemory::SetClearMemory(false);   // Claer plc virtual memory

    JGEquipment * equipment = (JGEquipment *)arg;
    if (dsnName != NULL)
    {
        equipment->setDSNName(dsnName);
    }
    if (plcName != NULL)
    {
        equipment->setPLCName(plcName);
    }

    equipment->init();

    equipment->start_comm();    // Start communicate to host

    // ACE_Thread_Manager::instance()->wait();

    _initialized = true;

    // ACE_DEBUG((LM_DEBUG, ACE_TEXT("Success gem::open\n")));

    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Gem_closeCmd --
 *
 *      This procedure is invoked to process the "gem::close"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Gem_closeCmd(ClientData arg, Tcl_Interp * interp, int objc,
                Tcl_Obj *CONST objv[])
{

    JGEquipment * jyugem = (JGEquipment *)arg;
    if (objc > 1)
    {
        Tcl_WrongNumArgs(interp, 1, objv, "close ?value value ...?");
        return TCL_ERROR;
    }

    if (_initialized)
    {
        jyugem->stop();
        _initialized = false;

        Tcl_AppendResult(interp, "****** Exit gem ******", NULL);

        // Tcl_Exit(0);
    }
    else
    {
        Tcl_AppendResult(interp, "Not opened gem", NULL);
        return TCL_ERROR;
    }

    return TCL_OK;
}


