// $Id: dbCmd.cpp,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    dbCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "JGEquipment.h"
#include "dbio/DBVariableElm.h"
#include "tclbee.h"

#ifdef _MSC_VER
#include <windows.h>
#endif

// function prototype

/*
 *----------------------------------------------------------------------
 *
 * Gem_dbCmd --
 *
 *      This procedure is invoked to process the "gem::db"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Gem_dbCmd(ClientData arg, Tcl_Interp * interp, int objc,
          Tcl_Obj *CONST objv[])
{
    // MELDeviceManager * melmngr;
    static char *gemcmds[] = {
        "load",
        "save",
        "update",
        "dump",
        NULL
    };
    /*
     * All commands enums below ending in X are compatibility
     */
    enum gemcmds {
        GEMDB_LOAD,
        GEMDB_SAVE,
        GEMDB_UPDATE,
        GEMDB_DUMP,
    };

    Tcl_Obj * res;
    int  cmdindex, result;
    char * objname;
    JGid vid;

    Tcl_ResetResult(interp);
    result = TCL_OK;

    JGEquipment * jyugem = (JGEquipment *)arg;

    if (objc < 2) {
        Tcl_WrongNumArgs(interp, 1, objv, "db");
        return TCL_ERROR;
    }
    /*
     * Get the command name index from the object based on the spoolcmds
     * defined above.
     */
    if (Tcl_GetIndexFromObj(interp,
        objv[1], (const char **)gemcmds, "db", TCL_EXACT, &cmdindex) != TCL_OK)
        return TCL_ERROR;

    res = NULL;
    switch ((enum gemcmds)cmdindex) {
    case GEMDB_LOAD:
        break;
    case GEMDB_UPDATE:
        objname = Tcl_GetStringFromObj(objv[2], NULL);
        vid = objname;
        DBVariableElm::update(jyugem, vid);
        break;
    case GEMDB_SAVE:
        break;
    case GEMDB_DUMP:
        break;

    }

    /*
     * For each different arg call different function to create
     * new commands (or if version, get/return it).
     */
    if (result == TCL_OK && res != NULL)
        Tcl_SetObjResult(interp, res);

    return TCL_OK;
}

