// $Id: JGWordSetSensor.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGWordSetSensor.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGWORDSETSENSOR_H
#define JGWORDSETSENSOR_H

#include "sac/JGIODevice.h"

class JGVariable;

//
// BitSet of class
//
class JGWordSetSensor : public JGIODevice
{
public:
    JGWordSetSensor();
    JGWordSetSensor(const JGIODevice& rhs);
    virtual ~JGWordSetSensor();

    JGWordSetSensor& operator=(const JGWordSetSensor& rhs);
    virtual int init();
    virtual int sense();

    int add(JGVariable * var);

//
protected:
    bool m_first;
    int  m_words;
    u_short * m_saved;
    u_short * m_readbuf;
    vector<JGVariable *> m_vars;

};


#endif  /* JGBITSETSENSOR_H */
