// $Id: JGIODevManager.cpp,v 1.6 2003/03/19 16:49:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGIODevManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGIODevManager.h"
#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGResourceManager.h"

static JGIODevManager * _manager = NULL;


//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGIODevManager::JGIODevManager() : JGManager(CATEGORY_IODEVICE)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGIODevManager::JGIODevManager");
}

//-----------------------------------------------------------------------------
JGIODevManager::~JGIODevManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGIODevManager::~JGIODevManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
JGIODevManager * JGIODevManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::instance");
    if (_manager == NULL)
    {
        _manager = new JGIODevManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGIODevManager::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::init");
    ACE_UNUSED_ARG(parm);

    linkDevices();

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Find the iodev
//-----------------------------------------------------------------------------
void JGIODevManager::linkDevices()
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::linkDevices");

    JGIODevice * iodev;
    JGIODeviceTable::iterator iter = m_iotable.begin();
    for ( ; iter != m_iotable.end(); iter++)
    {
        iodev = (*iter).second;
        m_iomap.insert(JGIONamePair(iodev->name(), iodev));
        JGResourceManager * rsc_mngr =
            (JGResourceManager *)m_equipment->findManager(CATEGORY_RESOURCE);
        JGSubSystem * subsys =
                rsc_mngr->findSubSystem(const_cast<JGid&>(iodev->sysid()));
        if (subsys != NULL)
        {
            iodev->subsystem(subsys);
            subsys->add(iodev);             // linked sub-system
        }
        else
        {
            TRACE_DEBUG((_TX("SubSystem(%s) is not found.\n"),
                         iodev->sysid().toString().c_str()));
        }
    }
}

//-----------------------------------------------------------------------------
// Find the iodev
//-----------------------------------------------------------------------------
JGIODevice * JGIODevManager::find(JGid& devid)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::find");

    JGIODevice * iodev;
    JGIODeviceTable::iterator iter = m_iotable.find(devid);
    if (iter == m_iotable.end())
    {
        return NULL;
    }
    iodev = (*iter).second;
    return iodev;
}

//-----------------------------------------------------------------------------
// Find the iodev by name
//-----------------------------------------------------------------------------
JGIODevice * JGIODevManager::findByName(const string& ioname)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::findByName");

    JGIODevice * iodev;
    JGIODeviceMap::iterator iter = m_iomap.find(ioname);
    if (iter == m_iomap.end())
    {
        return NULL;
    }
    iodev = (*iter).second;
    return iodev;
}

//-----------------------------------------------------------------------------
// Find the iodev
//-----------------------------------------------------------------------------
JGIODevice * JGIODevManager::find(JGVariable * var)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::find");

    JGIODevice * iodev;
    JGIODeviceMap::iterator iter = m_iomap.find(var->name());
    if (iter == m_iomap.end())
    {
        return NULL;
    }
    iodev = (*iter).second;
    return iodev;
}

//-----------------------------------------------------------------------------
// Set clock to plc (Dummy Method)
//-----------------------------------------------------------------------------
int JGIODevManager::setClock(struct tm& newtm)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::setClock");

    return m_equipment->setClock(newtm); 
}

//-----------------------------------------------------------------------------
// Get clock from plc (Dummy Method)
//-----------------------------------------------------------------------------
int JGIODevManager::getClock(struct tm& rettm)
{
    TRACE_FUNCTION(TRL_LOW, "JGIODevManager::getClock");

    return m_equipment->getClock(rettm); 
}

