// $Id: ExecutionRecipeModel.h,v 1.2 2002/10/12 09:11:52 fukasawa Exp $

//=============================================================================
/**
 *  @file    ExecutionRecipeModel.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef EXECUTIONRECIPEMODEL_H
#define EXECUTIONRECIPEMODEL_H

#include "jyugem.h"

//
class ExecutionRecipeModel
{
    friend class JGRecipe;

public:
    ExecutionRecipeModel() : m_rcpid(0), m_class(_TX("/PROCESS")),
                             m_version(_TX("1.0")), m_attrLength(0), 
                             m_bodyLength(0), m_bodyFormat(0),
                             m_attrChgTime(_TX("")), m_editTime(_TX("")),
                             m_linked(false), m_verified(false),
                             m_path(_TX("")), m_comment(_TX("")) {}
    virtual ~ExecutionRecipeModel() {}

    virtual int getBody(string& xml) = 0;
    virtual int getBody(JGvalue& body) = 0;  // binary format
    virtual int setBody(JGvalue& body) = 0;  // binary format
    virtual int setBody(string& xml) = 0;

protected:
    JGid  m_rcpid;
    string m_class;
    string m_version;
    size_t m_attrLength;
    size_t m_bodyLength;
    int    m_bodyFormat;                // SOURCE = 0, OBJ = 1
    string m_attrChgTime;
    string m_editTime;
    bool   m_linked;
    bool   m_verified;
    string m_comment;

    string m_path;                      // recipe file name
};


#endif  /* EXECUTIONRECIPEMODEL_H */
