// $Id: DBVariableElm.cpp,v 1.4 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBVariableElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "DBVariableElm.h"

//-----------------------------------------------------------------------------
// Load from database.
//-----------------------------------------------------------------------------
void DBVariableElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBVariableElm::load");

    JGInfoManager * infoManager =
                        (JGInfoManager *)equip->findManager(CATEGORY_INFO);
    JGVariableTable * var_tbl = infoManager->varTable();
    DBView<DBVariableElm> view(_TX("G_VARIABLES"));
    DBView<DBVariableElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBVariableElm * varElm = (DBVariableElm *)(&(*read_it));
        JGid id(varElm->m_vidStr);
        varElm->vid(id);                // Convert string to id.
        JGid userid(varElm->m_ecsvidStr);
        varElm->user_id(userid);        // Convert string to id.
        if (varElm->strToAttrs() != BEE_SUCCESS)
        {   // Convert type error.
            TRACE_ERROR((_TX("The variable(%s) has illegal value type.\n"),
                         varElm->m_vidStr.c_str()));
        }
        JGid ioid(varElm->m_iodevStr);
        varElm->iodev(ioid);            // Convert string to iodev.
        varElm->m_limitEnabled = (varElm->m_limitStr == _TX("true")) ?
                                 true : false;
        varElm->m_enabled = (varElm->m_enabledStr == _TX("true")) ?
                                 true : false;
        varElm->m_save = (varElm->m_saveStr == _TX("true")) ? true : false;

        var_tbl->insert(JGVarPair(id, (const JGVariable&)*read_it));
    }
    return ;
}

//-----------------------------------------------------------------------------
// Update variable.
//-----------------------------------------------------------------------------
int DBVariableElm::update(JGEquipment * equip, JGid& vid)
{
    TRACE_FUNCTION(TRL_LOW, "DBVariableElm::update");

    JGVariable * variable = equip->variable(vid);
    if (variable == NULL)
    {
        TRACE_ERROR((_TX("Illegal variable id (%s)\n"),
                     vid.toString().c_str()));
        return BEE_ERROR;
    }
    DBView<DBVariableElm> view(_TX("G_VARIABLES"), UPDVariableElm(),
                               _TX("WHERE VID = (?)"));
    DBView<DBVariableElm>::update_iterator updater = view;

    DBVariableElm varElm;
    varElm = *variable;
    varElm.formdb();    // Make data
    *updater = varElm;
    updater.Params().m_vidStr = varElm.m_vidStr;
    updater++;
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Save to database.
//-----------------------------------------------------------------------------
void DBVariableElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBVariableElm::save");

    JGInfoManager * infoManager =
                        (JGInfoManager *)equip->findManager(CATEGORY_INFO);
    JGVariableTable * var_tbl = infoManager->varTable();

    DBView<DBVariableElm> view(_TX("G_VARIABLES"), UPDVariableElm(),
                               _TX("WHERE VID = (?)"));
    DBView<DBVariableElm>::update_iterator updater = view;
    JGVariableTable::iterator var_it = var_tbl->begin();
    for ( ; var_it != var_tbl->end(); ++var_it)
    {
        DBVariableElm varElm = (*var_it).second;
        if (varElm.m_class == ECV || varElm.m_save == true)
        {
            varElm.formdb();
            *updater = varElm;
            updater.Params().m_vidStr = varElm.m_vidStr;
            updater++;
        }
    }
    return ;
}

//-----------------------------------------------------------------------------
// Format data of database.
//-----------------------------------------------------------------------------
int DBVariableElm::formdb()
{
    TRACE_FUNCTION(TRL_LOW, "DBVariableElm::formdb");

    m_id.get(m_vidStr);
    m_curval.get(m_initvalStr);
    return BEE_SUCCESS;
}

