// $Id: DBSpoolElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBSpoolElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBSPOOLELM_H
#define DBSPOOLELM_H

#include "dbio.h"

class JGEquipment;

#ifndef SFCODE
#define SFCODE(s,f)         (((s) << 8) | (f))
#endif

// Define an object to hold configure data
class DBSpoolElm
{
public:
    DBSpoolElm() : m_stream(0), m_func(0) { }
    DBSpoolElm(int streamNum, int funcNum)
        : m_stream(streamNum), m_func(funcNum) { }

    friend class dtl::DefaultBCA<DBSpoolElm>;
    friend class dtl::DefaultInsValidate<DBSpoolElm>;
    friend class dtl::DefaultSelValidate<DBSpoolElm>;

    friend bool operator<(const DBSpoolElm &val1, const DBSpoolElm &val2)
    {
        if (val1.m_stream == val2.m_stream)
            return (val1.m_func < val2.m_func);
        return (val1.m_stream < val2.m_stream);
    }

    int sfnum() const { return SFCODE(m_stream, m_func); }

    static void load(JGEquipment * equip);

protected:
    int m_stream;
    int m_func;
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBSpoolElm>
{
public:
    void operator()(BoundIOs &cols, DBSpoolElm &row)
    {
        cols[_TX("STREAM_NUM")] == row.m_stream;
        cols[_TX("FUNCTION_NUM")] == row.m_func;
    }
};

// Specialization of DefaultInsValidate for DBSpoolElm
// This defines a business rule we wish to enforce for all
// DBSpoolElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBSpoolElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBSpoolElm &rowbuf) {
        // data is valid if rowbuf.m_name is nonempty and
        // rowbuf.m_category is nonempty
        return (rowbuf.m_stream > 1 && is_odd(rowbuf.m_func));
    }
};

template<> class DefaultSelValidate<DBSpoolElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBSpoolElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBSPOOLELM_H */
