// $Id: DBIODeviceElm.cpp,v 1.9 2003/03/11 14:45:16 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBIODeviceElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "sac/JGIODevManager.h"
#include "sac/JGBitSetSensor.h"
#include "sac/JGWordSetSensor.h"
#include "dbio/DBIODeviceElm.h"
#include "PLCDeviceManager.h"

extern int setSystemFunction(JGVariable * var);
extern int setLibFunction(JGVariable * var);

//-----------------------------------------------------------------------------
//
void DBIODeviceElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBIODeviceElm::load");

    // Initial virtual memory for debug
#if 1
    string pname = equip->rootDirectory();
    pname += DIR_SEPARATOR_STRING;
    pname += equip->getConf(CONF_MMAP_FILENAME);
    PLCDeviceManager * plcmngr = equip->getPLCManager();
    plcmngr->init(pname.c_str());
#endif

    JGIODevManager * iodevManager =
                        (JGIODevManager *)equip->findManager(CATEGORY_IODEVICE);
    JGIODeviceTable * iodev_tbl = iodevManager->iodevTable();
    DBView<DBIODeviceElm> view(_TX("G_SAC"));
    JGvalue value;
    JGid    id;

    DBView<DBIODeviceElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBIODeviceElm * iodev = (DBIODeviceElm *)(&(*read_it));
        id = iodev->m_devidStr;
        iodev->devid(id);
        id = iodev->m_sysidStr;
        iodev->sysid(id);

        int format = ATOM_UINT4;
        if (iodev->format() == BIT || iodev->format() == BITSET)
        {
            format = ATOM_BOOLEAN;
        }
        else if (iodev->format() == STRING)
        {
            format = ATOM_ASCII;
        }
        iodev->m_maxval.set(iodev->m_maxvalStr, format);
        iodev->m_minval.set(iodev->m_minvalStr, format);
        iodev->m_deltaval.set(iodev->m_deltavalStr, format);

        BS2TimeValue tv = iodev->m_interval_time;
        iodev->interval(tv);
        tv = iodev->m_access_time;
        iodev->access(tv);
        iodev->timeEnable((iodev->m_timeEnableStr == _TX("true")) ? true : false);
        iodev->reset((iodev->m_resetStr == _TX("true")) ? true : false);

        PLCAccess plcadr;
        int ret = plcmngr->parseAddress(iodev->m_addressStr, plcadr);
        if (ret < 0)
        {
            TRACE_ERROR((_TX("Illegal plc address(%s)\n"),
                         iodev->m_addressStr.c_str()));
            continue ;
        }
        else
        {
            PLCDevice * memptr = plcadr.memory();
            iodev->m_plc.m_memory = memptr;

            long addr = memptr->convAddress(iodev->m_addressStr);
            plcadr.PLCAddress::set(memptr->devCode(), addr);
        }

        iodev->manager(iodevManager);

        JGIODevice * sac;
        if (iodev->datatype() == JGIODevice::VECTOR &&
            iodev->format() == JGIODevice::STRING)
        {
            iodev->m_plc = plcadr;
            sac = new JGIODevice(*iodev);
            iodev_tbl->insert(JGIODevicePair(iodev->devid(), sac));
        }
        else if (iodev->datatype() == JGIODevice::VECTOR)
        {   // WORD or BIT
            BCHAR buf[512];
            BCHAR fmt[256];
            _tcscpy(fmt, iodev->devid().toString().c_str());
            if (_tcsstr(fmt, _TX("%d")) == NULL)
            {
                TRACE_ERROR((_TX("Illegal device id format(%s)\n"), fmt));
                ACE_ERROR((LM_ERROR, ACE_TEXT("Append numbering format\n")));
                _tcscat(fmt, _TX("%d"));
            }
            for (int i = 1; i <= iodev->dim(); i++)
            {
                _stprintf(buf, fmt, i);
                string namestr = buf;
                JGid mbrid = buf;
                iodev->devid(mbrid);
                iodev->name(namestr);
                plcadr += (long)iodev->dataq();
                iodev->m_plc = plcadr;
                sac = new JGIODevice(*iodev);
                iodev_tbl->insert(JGIODevicePair(iodev->devid(), sac));
            }
        }
        else
        {
            iodev->m_plc = plcadr;
            if (iodev->format() == JGIODevice::BITSET)
            {
                JGBitSetSensor * bitsns = new JGBitSetSensor(*iodev);
                sac = (JGIODevice *)bitsns;
            }
            else if (iodev->format() == JGIODevice::WORDSET)
            {
                JGWordSetSensor * wordsns = new JGWordSetSensor(*iodev);
                sac = (JGIODevice *)wordsns;
            }
            else
            {
                sac = new JGIODevice(*iodev);
            }
            iodev_tbl->insert(JGIODevicePair(iodev->devid(), sac));
        }
    }

    return ;
}
