// $Id: DBEventElm.cpp,v 1.5 2003/03/19 16:49:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBEventElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGEventManager.h"
#include "dbio/DBEventElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBEventElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBEventElm::load");

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGEventTable * event_tbl = eventManager->eventTable();
    DBView<DBEventElm> view(_TX("G_EVENT"));

    DBView<DBEventElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBEventElm * event = (DBEventElm *)(&(*read_it));
        JGid id(event->m_ceidStr);
        event->ceid(id);
        if (event->m_enabledStr == _TX("true"))
            event->enabled(true);
        else
            event->enabled(false);

        event->manager(eventManager);
        event_tbl->insert(JGEventPair(id, *read_it));
    }

    // Convert ASCII data
    JGActionTable * act_tbl = JGEventManager::instance()->actionTable();
    JGEventTable::iterator event_it = event_tbl->begin();
    for ( ; event_it != event_tbl->end(); ++event_it)
    {
        JGEvent * evt = &((*event_it).second);

        if (evt->actionName().size() > 0)
        {
            act_tbl->insert(JGActionPair(evt->actionName(), evt->ceid()));
        }
    }
    return ;
}

//-----------------------------------------------------------------------------
// Update variable.
//-----------------------------------------------------------------------------
int DBEventElm::update(JGEquipment * equip, JGid& ceid)
{
    TRACE_FUNCTION(TRL_LOW, "DBEventElm::update");

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGEvent * event = eventManager->find(ceid);
    if (event == NULL)
    {
        TRACE_ERROR((_TX("Illegal event id (%s)\n"), ceid.toString().c_str()));
        return BEE_ERROR;
    }
    DBView<DBEventElm> view(_TX("G_EVENT"), UPDEventElm(),
                            _TX("WHERE CEID = (?)"));
    DBView<DBEventElm>::update_iterator updater = view;

    DBEventElm eventElm;
    eventElm = *event;
    eventElm.formdb();    // Make data
    *updater = eventElm;
    updater.Params().m_ceidStr = eventElm.m_ceidStr;
    updater++;
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Save to database.
//-----------------------------------------------------------------------------
void DBEventElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBEventElm::save");

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGEventTable * event_tbl = eventManager->eventTable();
    DBView<DBEventElm> view(_TX("G_EVENT"), UPDEventElm(),
                            _TX("WHERE CEID = (?)"));
    DBView<DBEventElm>::update_iterator updater = view;
    JGEventTable::iterator evt_it = event_tbl->begin();
    for ( ; evt_it != event_tbl->end(); ++evt_it)
    {
        DBEventElm eventElm = (*evt_it).second;
        eventElm.formdb();
        *updater = eventElm;
        updater.Params().m_ceidStr = eventElm.m_ceidStr;
        updater++;
    }
    return ;
}

//-----------------------------------------------------------------------------
// Format data of database.
//-----------------------------------------------------------------------------
int DBEventElm::formdb()
{
    TRACE_FUNCTION(TRL_LOW, "DBEventElm::formdb");

    m_id.get(m_ceidStr);
    m_enabledStr = (this->enabled()) ? _TX("true") : _TX("false");
    return BEE_SUCCESS;
}


//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBEvtReportElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBEvtReportElm::load");

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGEventTable * event_tbl = eventManager->eventTable();
    JGReportTable * report_tbl = eventManager->reportTable();
    DBView<DBEvtReportElm> view(_TX("G_EVT_REPORT"));

    DBView<DBEvtReportElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBEvtReportElm * evtrpt = (DBEvtReportElm *)(&(*read_it));
        JGid ceid(evtrpt->m_ceidStr);
        evtrpt->ceid(ceid);
        JGid rptid(evtrpt->m_rptidStr);
        evtrpt->rptid(rptid);
        JGEventTable::iterator evt_it = event_tbl->find(ceid);
        JGReportTable::iterator rpt_it = report_tbl->find(rptid);
        if (evt_it != event_tbl->end() && rpt_it != report_tbl->end())
        {
            // append report
            JGEvent * evt = &((*evt_it).second);
            JGReport * rpt = &((*rpt_it).second);
            evt->insert(rpt);
        }
    }
    return ;
}

//-----------------------------------------------------------------------------
// Save data.
//-----------------------------------------------------------------------------
void DBEvtReportElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBEvtReportElm::save");

    DBStmt(_TX("TRUNCATE TABLE G_EVT_REPORT")).Execute();

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGEventTable * event_tbl = eventManager->eventTable();
    DBView<DBEvtReportElm> view(_TX("G_EVT_REPORT"));

    DBView<DBEvtReportElm>::insert_iterator write_it = view;
    JGEventTable::iterator evt_it = event_tbl->begin();
    for ( ; evt_it != event_tbl->end(); evt_it++)
    {
        JGEvent * event = &((*evt_it).second);
        string ceid;
        event->ceid().get(ceid);
        JGReports * report_tbl = event->reportSet();
        for (size_t i = 0; i < report_tbl->size(); i++)
        {
            JGid rptid((*report_tbl)[i]->rptid());
            DBEvtReportElm evtrpt;
            evtrpt.m_ceidStr = ceid;
            rptid.get(evtrpt.m_rptidStr);
            evtrpt.m_seqnum = i + 1;
            *write_it = evtrpt;
            write_it++;
        }
    }
    return ;
}

