// $Id: DBConfigElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBConfigElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBCONFIGELM_H
#define DBCONFIGELM_H

#include "dbio.h"
#include "JGConfig.h"

class JGEquipment;

// Define an object to hold configure data
class DBConfigElm : public JGConfig
{
public:
    DBConfigElm() : JGConfig() { }

    friend class dtl::DefaultBCA<DBConfigElm>;
    friend class dtl::DefaultInsValidate<DBConfigElm>;
    friend class dtl::DefaultSelValidate<DBConfigElm>;

    friend bool operator<(const DBConfigElm &val1, const DBConfigElm &val2)
    {
        return (strcmp(val1.m_name.c_str(), val2.m_name.c_str()) < 0);
    }

    static void load(JGEquipment * equip);

protected:
    string m_vidstr;
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBConfigElm>
{
public:
    void operator()(BoundIOs &cols, DBConfigElm &row)
    {
        cols[_TX("PARM_NAME")] == row.m_name;
        cols[_TX("VALUE")] == row.m_value;
        cols[_TX("UNIT")] == row.m_unit;
        cols[_TX("CATEGORY")] == row.m_category;
        cols[_TX("SUB_CATEGORY")] == row.m_sub_category;
        cols[_TX("VID")] == row.m_vidstr;
    }
};

// Specialization of DefaultInsValidate for DBConfigElm
// This defines a business rule we wish to enforce for all
// DBConfigElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBConfigElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBConfigElm &rowbuf) {
        // data is valid if rowbuf.m_name is nonempty and
        // rowbuf.m_category is nonempty
        return (rowbuf.m_name.length() > 0 && rowbuf.m_category.length() > 0);
    }
};

template<> class DefaultSelValidate<DBConfigElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBConfigElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBCONFIGELM_H */
