// $Id: DBAlarmElm.cpp,v 1.4 2003/03/22 16:41:44 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBAlarmElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGAlarmManager.h"
#include "dbio/DBAlarmElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBAlarmElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBAlarmElm::load");

    JGInfoManager * infoManager = equip->getInfoManager();
    JGAlarmManager * alarmManager = equip->getAlarmManager();
    JGAlarmTable * alarm_tbl = alarmManager->alarmTable();
    DBView<DBAlarmElm> view(_TX("G_ALARM"));

    DBView<DBAlarmElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBAlarmElm * alarmElm = (DBAlarmElm *)(&(*read_it));
        JGid vid(alarmElm->m_vidStr);
        alarmElm->vid(vid);
        u_int alnum = strtoul(alarmElm->m_alidStr.c_str(), NULL, 0);
        JGid alid(alnum);
        alarmElm->alid(alid);
        bool enable_state = (alarmElm->m_enabledStr == _TX("true")) ?
                            true : false;
        alarmElm->enabled(enable_state);
        bool init_state = (alarmElm->m_almstatusStr == _TX("true")) ?
                            true : false;
        alarmElm->status(init_state);
        alarmElm->manager(alarmManager);
        alarm_tbl->insert(JGAlarmPair(alid, *read_it));
    }

    return ;
}

//-----------------------------------------------------------------------------
// Update variable.
//-----------------------------------------------------------------------------
int DBAlarmElm::update(JGEquipment * equip, JGid& alid)
{
    TRACE_FUNCTION(TRL_LOW, "DBAlarmElm::update");

    JGAlarmManager * alarmManager =
                        (JGAlarmManager *)equip->findManager(CATEGORY_ALARM);
    JGAlarm * alarm = alarmManager->find(alid);
    if (alarm == NULL)
    {
        TRACE_ERROR((_TX("Illegal alarm id (%s)\n"), alid.toString().c_str()));
        return BEE_ERROR;
    }
    DBView<DBAlarmElm> view(_TX("G_ALARM"), UPDAlarmElm(),
                            _TX("WHERE ALID = (?)"));
    DBView<DBAlarmElm>::update_iterator updater = view;

    DBAlarmElm alarmElm;
    alarmElm = *alarm;
    alarmElm.formdb();    // Make data
    *updater = alarmElm;
    updater.Params().m_alidStr = alarmElm.m_alidStr;
    updater++;
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Save to database.
//-----------------------------------------------------------------------------
void DBAlarmElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBAlarmElm::save");

    JGAlarmManager * alarmManager =
                        (JGAlarmManager *)equip->findManager(CATEGORY_ALARM);
    JGAlarmTable * alarm_tbl = alarmManager->alarmTable();
    DBView<DBAlarmElm> view(_TX("G_ALARM"), UPDAlarmElm(),
                            _TX("WHERE ALID = (?)"));
    DBView<DBAlarmElm>::update_iterator updater = view;
    JGAlarmTable::iterator alarm_it = alarm_tbl->begin();
    for ( ; alarm_it != alarm_tbl->end(); ++alarm_it)
    {
        DBAlarmElm alarmElm = (*alarm_it).second;
        alarmElm.formdb();
        *updater = alarmElm;
        updater.Params().m_alidStr = alarmElm.m_alidStr;
        updater++;
    }
    return ;
}

//-----------------------------------------------------------------------------
// Format data of database.
//-----------------------------------------------------------------------------
int DBAlarmElm::formdb()
{
    TRACE_FUNCTION(TRL_LOW, "DBAlarmElm::formdb");

    m_id.get(m_alidStr);
    m_vid.get(m_vidStr);
    m_enabledStr = (this->enabled()) ? _TX("true") : _TX("false");
    m_almstatusStr = (this->status()) ? _TX("true") : _TX("false");
    return BEE_SUCCESS;
}


