// $Id: JGTraceManager.h,v 1.6 2003/02/23 11:00:18 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTraceManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTRACEMANAGER_H
#define JGTRACEMANAGER_H

#include "JGManager.h"
#include "JGTrace.h"
#include "ace/Timer_Heap_T.h"
#include "ace/Timer_Queue.h"
#include "ace/Timer_Heap.h"
#include "ace/Timer_Queue_Adapters.h"

/*
 *
 */
class JGTraceManager: public JGManager
{
public:
    JGTraceManager();
    ~JGTraceManager();

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    JGTraceTable * traceTable() { return &m_traces; }
    JGTraceTable * keepTable()  { return &m_keepTraces; }

    int start(JGid& trid);
    int cancel(JGid& trid);
    int entry(JGTrace * trinfo);        // set into active table
    int remove(JGid& trid);
    BS2Message * traceInit(BS2Message * msg);

    static JGTraceManager * instance();

private:
    int initKeeping(int = 0);
    JGTrace * find(JGid& trid);
    JGTrace * getKeeping(JGid& trid);
    static int parseS2F23(void * clientData, BS2Item * item);
//
private:
    int m_maxtrace;
    int m_maxsvid;
    JGTraceTable m_keepTraces;          // from DB (not used)
    JGTraceTable m_traces;              // active
};


#endif
