// $Id: JGTrace.h,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTrace.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTRACE_H
#define JGTRACE_H

#include "JGNameInfo.h"
#include "JGVariable.h"
#include "BS2TimeValue.h"

class BS2Message;
class JGTraceManager;

// Define an object to hold configure data
class JGTrace : public JGNameInfo, ACE_Handler
{
    friend class JGTraceManager;

public:
    JGTrace() : JGNameInfo(), ACE_Handler(), m_dsper(_TX("")),
                m_totsmp(0), m_repgsz(0),
                m_cursmp(0), m_stime(ACE_OS::gettimeofday()) {}
    virtual ~JGTrace() {}
    virtual void  printOn(string& buf, int mode = 0);

    virtual void handle_time_out(const ACE_Time_Value &tv,
                                 const void *arg);

    JGTrace& operator=(const JGTrace& rhs);
    void insert(JGVariable * var) { m_vars.push_back(var); }

    JGid&  trid()              { return m_id; }
    void   trid(JGid& id)      { m_id = id;  m_id.get(m_name); }
    void   totsmp(int totsmp)  { m_totsmp = totsmp; }
    void   repgsz(int repgsz)  { m_repgsz = repgsz; }
    void   dsper(string dsper) { m_dsper = dsper; }
    void   manager(JGTraceManager * mngr) { m_manager = mngr; }
    int    varSize()           { return m_vars.size(); }
    JGVariables& vars()        { return m_vars; }

    void convertime();              // DSPER: string to TimeValue
    void sampling();                // Sampling variables of trace
    BS2Message * create();          // Create SECS Message (S6F1)

protected:
    string m_dsper;
    int    m_totsmp;
    int    m_repgsz;
    JGVariables m_vars;
    //
    JGTraceManager * m_manager;
    u_long  m_cursmp;               // current sampling count (SMPLN)
    long    m_tmid;                 // timer id
    BS2TimeValue m_dspertv;
    BS2TimeValue m_stime;
    BS2values m_values;             // sampled data list

};

typedef map<JGid, JGTrace, id_less, allocator<JGTrace> > JGTraceTable;
typedef JGTraceTable::value_type  JGTracePair;
typedef list<JGTrace *> JGTraces;
typedef list<JGTrace>   JGTraceList;

#endif  /* JGTRACE_H */
