// $Id: JGTime.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTime.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTIME_H
#define JGTIME_H

#include "jyugem.h"
#include "b_time.h"

class BS2Item;

//-----------------------------------------------------------------------------
// JYUGEM time class.
//-----------------------------------------------------------------------------
class JGTime : public b_time
{
public:
    JGTime() : b_time() {}
    JGTime(const struct tm& tv)      : b_time(tv) {}
    JGTime(const ACE_Time_Value& tv) : b_time(tv) {}
    JGTime(const JGTime& rhs)        : b_time(rhs) {}
    ~JGTime() {}

    JGTime operator=(const JGTime& rhs) {
            if (this == &rhs)
                return *this;
            this->b_time::copy(rhs);
            return *this;
        }

    BS2Item * makeItem(const BCHAR * iname = NULL);
};


#endif  // JGTIME_H
