// $Id: JGTerminalManager.h,v 1.5 2003/02/09 16:15:13 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTerminalManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTERMINALMANAGER_H
#define JGTERMINALMANAGER_H

#include "JGManager.h"


/*
 *
 */
class JGTerminalManager: public JGManager
{
public:
    JGTerminalManager();
    ~JGTerminalManager();

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    static JGTerminalManager * instance();

private:
    int notAllowMultiBlock();                       // send S10F7
    BS2Message * dispBlock(BS2Message * msg);       // received S10F3
    BS2Message * dispMultiBlock(BS2Message * msg);  // received S10F5

// member variables
private:
    JGVariable * m_hostmsg;          // Host Message
    JGVariable * m_recognition;      // Host Message Recognized
    JGVariable * m_received;         // Host Message Received
    JGVariable * m_termmsg;          // Terminal Message
    JGVariable * m_termreq;          // Request to send Terminal Message
    int          m_termCount;        // Terminal count
};


#endif
