// $Id: JGTaskTrigger.cpp,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTaskTrigger.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL


#include "JGTaskTrigger.h"
#include "JGManager.h"
#include "BS2Message.h"

//-----------------------------------------------------------------------------
//
// SECS Message Trigger
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  Constructor/Destructor
//-----------------------------------------------------------------------------
JGMessageTrigger::JGMessageTrigger(BS2MessageInfo& msginfo) : JGTrigger()
{
    m_msginfo = msginfo;          // Move message;
    m_msg = m_msginfo.getMessageAndClear();
    m_subject = m_msg->name();
}


//-----------------------------------------------------------------------------
//  Call to parse message service
//-----------------------------------------------------------------------------
int JGMessageRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGMessageRequest::call");

    JGManager * manager = (JGManager *)m_task;
    JGMessageTrigger * msgtrig = (JGMessageTrigger *)m_trigger;
    BS2Message * msg = msgtrig->message();
    BS2Message * replymsg;
    if (msg != NULL)
    {
        // Goto each manager
        replymsg =  manager->msg_svc(msgtrig, msg);  // Each Manager

        msgtrig->message(NULL);
        delete msg;

        if (replymsg != NULL)
        {
            manager->send(replymsg);
        }
    }
    else
    {   // Illegal response
        TRACE_ERROR((_TX("%s manager is received null message .\n"),
                    manager->charName()));
    }
    return 0;
}


//-----------------------------------------------------------------------------
//
// I/O Device Trigger
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  Constructor/Destructor
//-----------------------------------------------------------------------------
JGDeviceTrigger::JGDeviceTrigger(const string& name, JGVariable * var,
                                 void * arg)
        : JGTrigger(name)
{
    m_variable = var;
    m_arg = arg;

}


//-----------------------------------------------------------------------------
//  Call to parse message service
//-----------------------------------------------------------------------------
int JGDeviceRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGDeviceRequest::call");

    JGManager * manager = (JGManager *)m_task;
    manager->device_svc((JGDeviceTrigger *)m_trigger);
    return 0;
}


//-----------------------------------------------------------------------------
//
// Operator Trigger
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  Constructor/Destructor
//-----------------------------------------------------------------------------
JGOperatorTrigger::JGOperatorTrigger(const string& name, const string& arg)
        : JGTrigger(name)
{
    ACE_UNUSED_ARG(arg);
}


//-----------------------------------------------------------------------------
//  Call to parse message service
//-----------------------------------------------------------------------------
int JGOperatorRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGOperatorRequest::call");

    JGManager * manager = (JGManager *)m_task;
    manager->ope_svc((JGOperatorTrigger *)m_trigger);
    return 0;
}

//-----------------------------------------------------------------------------
//
// Notify Trigger
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  Call to parse message service
//-----------------------------------------------------------------------------
int JGNotifyRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGNotifyRequest::call");

    JGManager * manager = (JGManager *)m_task;
    manager->notify_svc((JGNotifyTrigger *)m_trigger);
    return 0;
}

//-----------------------------------------------------------------------------
//
// Remote Command Trigger
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  Call to parse message service
//-----------------------------------------------------------------------------
int JGRemoteRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGRemoteRequest::call");

    JGManager * manager = (JGManager *)m_task;
    manager->rcmd_svc((JGService *)m_trigger);
    return 0;
}

