// $Id: JGSubSystem.cpp,v 1.6 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGSubSystem.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGSubSystem.h"
#include "JGResourceManager.h"
#include "JGVariable.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"
#include "JGObject.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGSubSystem::JGSubSystem(const JGSubSystem& rhs) : JGNameInfo(rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGSubSystem::JGSubSystem");
    m_locid = rhs.m_locid;
    m_systype = rhs.m_systype;
    m_relocNum = rhs.m_relocNum;
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
void JGSubSystem::copy(const JGSubSystem& rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGSubSystem::copy");
    this->JGNameInfo::copy(rhs);
    m_locid = rhs.m_locid;
    m_systype = rhs.m_systype;
    m_relocNum = rhs.m_relocNum;
}

