// $Id: JGSpecification.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGSpecification.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSPECIFICATION_H
#define JGSPECIFICATION_H

#include "jyugem.h"

class JGClass;
class JGObject;
class JGErrorList;
class BS2Item;
class BS2ListItem;

typedef b_objtypeMap   ClassMap;
typedef b_objectMap    ObjectMap;
typedef b_objtypePair  ClassPair;
typedef b_objectPair   ObjectPair;


//
// Specification
//
class JGSpecification : public b_specification
{
public:
    JGSpecification() : b_specification() {}
    JGSpecification(const string& name) : b_specification(name) {}
    JGSpecification(const BCHAR * name) : b_specification(name) {}
    ~JGSpecification() {}

    int getObjTypes(BS2ListItem * olist);    // for S14F6
    int getAllClasses(vector<JGClass *>& clazzes);
    int getAllObjects(vector<JGObject *>& objs);

    // Wrapper methods
    inline JGClass * find(const string& clazzid) {
            return reinterpret_cast<JGClass *>(this->b_specification::find(clazzid));
        }
    inline JGObject * findObject(const string& objid) {
            return reinterpret_cast<JGObject *>(this->b_specification::findObject(objid));
        }

protected:
};

#endif  /* JGSPECIFICATION_H */
