// $Id: JGRemoteCmd.h,v 1.2 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRemoteCmd.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGREMOTECMD_H
#define JGREMOTECMD_H

#include "jyugem.h"

/*
 * Command's parameter :  (for S2F41 or S2F49)
 */
struct CmdParam
{
    string  m_cpname;
    JGvalue m_cpval;

    CmdParam(): m_cpname(_TX("")), m_cpval(0) {}
    CmdParam(const CmdParam& rhs) {
        m_cpname = rhs.m_cpname; m_cpval = rhs.m_cpval;
    }
    CmdParam& operator=(const CmdParam& rhs) {
        if (this == &rhs)
            return *this;
        m_cpname = rhs.m_cpname; m_cpval = rhs.m_cpval;
        return *this;
    }
};

typedef map<string, CmdParam *, str_less, allocator<CmdParam *> >
        JGCmdParamTable;
typedef JGCmdParamTable::value_type JGCmdParamPair;

//
// Remote command & parameter (for S2F41 or S2F49)
//
struct JGRemoteCmd
{
    string m_rcmd;
    USHORT m_cmdcode;
    string m_objspec;
    vector<CmdParam> m_parms;
    JGCmdParamTable  m_paramap;

    JGRemoteCmd() : m_rcmd(_TX("")), m_objspec(_TX("")) {}
    JGRemoteCmd(const string& rcmd, int code, const string& target)
            : m_rcmd(rcmd), m_cmdcode(code), m_objspec(target) {}
    JGRemoteCmd(const JGRemoteCmd& rhs) {
        m_rcmd = rhs.m_rcmd;  m_objspec = rhs.m_objspec;
        m_parms = rhs.m_parms;
    }

    JGRemoteCmd& operator=(const JGRemoteCmd& rhs) {
        if (this == &rhs)
            return *this;
        m_rcmd = rhs.m_rcmd;  m_objspec = rhs.m_objspec;
        m_parms = rhs.m_parms;
        return *this;
    }
    CmdParam * find(const string& cpname) {
        JGCmdParamTable::iterator iter = m_paramap.find(cpname);
        if (iter == m_paramap.end())
            return NULL;
        return (*iter).second;
    }
};

//
// Containers
//
typedef map<string, JGRemoteCmd *, str_less, allocator<JGRemoteCmd *> >
        JGRemoteCmdTable;
typedef JGRemoteCmdTable::value_type JGRemoteCmdPair;
typedef vector<JGRemoteCmd> JGRemoteCmds;
typedef list<JGRemoteCmd *> JGRemoteCmdList;

#endif  /* JGREMOTECMD_H */
