// $Id: JGRecipeClass.cpp,v 1.6 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRecipeClass.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGRecipeClass.h"
#include "JGRecipe.h"
#include "JGClass.h"
#include "JGObject.h"
#include "JGAttribute.h"

static JGAttribute _attrNameSpace(_TX("NameSpace"), ATOM_ASCII);
static JGAttribute _attrName(_TX("Name"),           ATOM_ASCII);
static JGAttribute _attrClass(_TX("Class"),         ATOM_ASCII);
static JGAttribute _attrVersion(_TX("Version"),     ATOM_ASCII);
static JGAttribute _attrExecAttrLength(_TX("ExecAttrLength"), ATOM_INT4);
static JGAttribute _attrExecChgTime(_TX("ExecChgTime"), ATOM_ASCII);
static JGAttribute _attrAttrLength(_TX("AttrLength"),   ATOM_INT4);
static JGAttribute _attrAttrChgTime(_TX("AttrChgTime"), ATOM_ASCII);
static JGAttribute _attrEditTime(_TX("EditTime"),       ATOM_ASCII);
static JGAttribute _attrBodyLength(_TX("BodyLength"),   ATOM_INT4);
static JGAttribute _attrBodyFormat(_TX("BodyFormat"),   ATOM_UINT1);
static JGAttribute _attrVerified(_TX("Verified"),       ATOM_BOOLEAN);
static JGAttribute _attrLinked(_TX("Linked"),           ATOM_BOOLEAN);
static JGAttribute _attrChangedBody(_TX("ChangedBody"), ATOM_BOOLEAN);
static JGAttribute _attrExecChgCtl(_TX("ExecChgCtl"),   ATOM_BINARY);
static JGAttribute _attrComment(_TX("Comment"),         ATOM_ASCII);
static JGAttribute _attrBody(_TX("Body"),               ATOM_ASCII);

static JGAttribute _attrParVal(_TX("ParVal"),   ATOM_ASCII);
static JGAttribute _attrParName(_TX("ParName"), ATOM_ASCII);
static JGStruct    _attrParameter(_TX("Parameter"));
static JGVector    _attrParameters(_TX("Parameters"), &_attrParameter);

//-----------------------------------------------------------------------------
// Initial execution recipe class.
//-----------------------------------------------------------------------------
int JGRecipeClass::init()
{
    TRACE_FUNCTION(TRL_LOW, "JGRecipeClass::init");

    _attrParameter.add(&_attrParName);
    _attrParameter.add(&_attrParVal);   // Parameter[]

    this->JGClass::initBase();
    this->add(&_attrNameSpace);
    this->add(&_attrName);
    this->add(&_attrClass);
    this->add(&_attrVersion);
    this->add(&_attrExecAttrLength);
    this->add(&_attrExecChgTime);
    this->add(&_attrAttrLength);
    this->add(&_attrAttrChgTime);
    this->add(&_attrEditTime);
    this->add(&_attrBodyLength);
    this->add(&_attrBodyFormat);
    this->add(&_attrVerified);
    this->add(&_attrLinked);
    this->add(&_attrChangedBody);
    this->add(&_attrExecChgCtl);
    this->add(&_attrParameters);
    this->add(&_attrComment);
    this->add(&_attrBody);

#if 1
    TypeNameMapping nameMap(_TX("JYUGEM.Recipe"));
    nameMap.add(_TX("NameSpace"), _TX("m_nameSpace"));
    nameMap.add(_TX("Name"),      _TX("m_name"));
    nameMap.add(_TX("Class"),     _TX("m_class"));
    nameMap.add(_TX("Version"),   _TX("m_version"));
    nameMap.add(_TX("ExecAttrLength"), _TX("m_execAttrLength"));
    nameMap.add(_TX("ExecChgTime"), _TX("m_execChgTime"));
    nameMap.add(_TX("AttrLength"),  _TX("m_attrLength"));
    nameMap.add(_TX("AttrChgTime"), _TX("m_attrChgTime"));
    nameMap.add(_TX("EditTime"),    _TX("m_editTime"));
    nameMap.add(_TX("BodyLength"),  _TX("m_bodyLength"));
    nameMap.add(_TX("BodyFormat"),  _TX("m_bodyFormat"));
    nameMap.add(_TX("Verified"),    _TX("m_verified"));
    nameMap.add(_TX("Linked"),      _TX("m_linked"));
    nameMap.add(_TX("ChangedBody"), _TX("m_changedBody"));
    nameMap.add(_TX("ExecChgCtl"),  _TX("m_execChgCtl"));
    nameMap.add(_TX("Comment"),     _TX("m_comment"));
    nameMap.add(_TX("Body"),        _TX("m_body"));
    nameMap.add(_TX("Parameters"),  _TX("m_parameters"));

    nameMap.add(_TX("Parameter"), _TX("m_parameter"));
    nameMap.add(_TX("ParVal"),    _TX("m_val"));
    nameMap.add(_TX("ParName"),   _TX("m_name"));
    this->mapping(nameMap);
#endif
    return BEE_SUCCESS;
}


//-----------------------------------------------------------------------------
// Print items of the limit
//-----------------------------------------------------------------------------
b_object * JGRecipeClass::instance(const BCHAR * name)
{
    TRACE_FUNCTION(TRL_LOW, "JGRecipeClass::instance");
    JGRecipe * obj = new JGRecipe(this, name);
    this->entry(obj);
    return obj;
}

