// $Id: JGRecipe.cpp,v 1.9 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRecipe.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGRecipe.h"
#include "JGRecipeManager.h"
#include "JGVariable.h"
#include "JGObject.h"
#include "JGAttrData.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Get recipe id
//-----------------------------------------------------------------------------
JGid JGRecipe::rcpid()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGRecipe::rcpid");
    ;
    int p = this->objid().find(':');
    string rcpspec = this->objid().substr(p + 1);
    JGid id(rcpspec);
    return id;
}

//-----------------------------------------------------------------------------
// Get body length
//-----------------------------------------------------------------------------
size_t JGRecipe::bodyLength()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGRecipe::bodyLength");
    size_t length;
    JGAttrData * attrdata = findData(_TX("BodyLength"));
    length = attrdata->get().getUInt();
    return length;
}

//-----------------------------------------------------------------------------
// Set recipe attributes from host message
//-----------------------------------------------------------------------------
int JGRecipe::set(vector<JGAttrFilter>& filter, JGErrorList& errlist)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGRecipe::set");
    ACE_UNUSED_ARG(errlist);

    JGAttrData * attrdata;
    JGvalue value;

    for (size_t i = 0; i < filter.size(); i++)
    {
        value = filter[i].m_attrdata;
        string parName;
        filter[i].m_attrid.get(parName);
        attrdata = findData(parName);
        if (attrdata != NULL)
        {
            attrdata->set(value);
        }
        else
        {   // As parameter name can't find,
            // make parameter list in recipe object
            RCmdParam param(parName, value);
            m_params.push_back(param);
        }
    }

    return 0;
}



